# MATH operations
#
# MATH operations are of the form A op B = C.  Thats pretty straight forward.
#   To make it less straight forward you can have multiple A,and B variables
#   in a single definition.  The rules are:

#   In all operations any constant values must be input in B.
#   In the basic operations (+, -, *, /)  you either have the same number of
#   A and B variables, 1 A value with multiple B values or 1 B value with
#   multiple A values.  You must have as many C variabled defines as the
#   maximum number of A or B values.
#  
#   With the SUM operator you can have unequal number of A and B values and
#   only 1 C value.  All constant values again go in B


package provide UDFAnalysis 1.0

proc APsolveMath { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {
       APkeepTabs "STEP $fD : MATH ($I)"

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s" _Va _Op _Vb _OuT

# GET the input A array variable list and setup first variable where applicable

      set rV [APgetVNames $_Va]
      set aN [lindex $rV 0]
      set bTypeA [lindex $rV 1]
      set vTypeA [lindex $bTypeA 0]
      set nA [llength $aN]
      if !$vTypeA {
         set vR [lindex $aN 0] ; global  [set vR] ; upvar 0 [set vR] _A
         set lA [expr [lindex $_A(Dim) 0] * [lindex $_A(Dim) 1]]
      } else { set lA 1 }

# GET the input B array variable list and setup first variable where applicable

      if ![string match $apANS(EmptyVar) $_Vb] {
         set rV [APgetVNames $_Vb]
         set bN [lindex $rV 0]
         set bTypeB [lindex $rV 1]
         set vTypeB [lindex $bTypeB 0]
         set nB [llength $bN]
         if !$vTypeB {
            set vR [lindex $bN 0] ; global  [set vR] ; upvar 0 [set vR] _B
	    if [info exists _B(Dim)] {
               set lB [expr [lindex $_B(Dim) 0] * [lindex $_B(Dim) 1]]
            } else { set lB 1 }
         }
      } else { set nB 0 ; set vTypeB -1 ; set lB 1}

# DETERMINE which if any variables are constants and set the variable names
#   of those which are not.
 
      if { ($vTypeA == 0) && ($vTypeB == 0) } {
         set vT AV_BV
      } elseif { ($vTypeA == 0) && ($vTypeB == 1) } {
         set vT AV_BC
      } elseif { ($vTypeA == 0) && ($vTypeB == -1) } {
         set vT AV
      } elseif { ($vTypeA == 1) && ($vTypeB == 0) } {
         set vT AC_BV
      } elseif { ($vTypeA == 1) && ($vTypeB == 1) } {
         set vT AC_BC
      } else { set vT AC }

# GET the output output array list

      set rV [APgetVNames $_OuT]
      set cN [lindex $rV 0]
      set nC [llength $cN]

# Max output array number
 
      set nMax $nA 
      if { $nB > $nMax } { set nMax $nB }
      if { $nC > $nMax } { set nMax $nC }

# DETERMINE the repitition factor.  Array A to be larger than array B by 
#    an integral amount in which case array B is repeated applied to A.
#    This allows for example all matrix columns to be multiplied by a 
#    single set of values.  This can be determined from the first
#    defined A and B variable.
 
      switch -exact -- $vT {
         AC_BC {
            set Reps 1
         }
	 AC {
            set vR [lindex $bN 0] ; global  [set vR] ; upvar 0 [set vR] _B
            set lB [expr [lindex $_B(Dim) 0] * [lindex $_B(Dim) 1]]
	    set Reps 1
	 }
	 AV_BC {
            set vR [lindex $aN 0] ; global  [set vR] ; upvar 0 [set vR] _A
	    set Reps 1
	 }
	 AV_BV {
            set vR [lindex $aN 0] ; global  [set vR] ; upvar 0 [set vR] _A
            set vR [lindex $bN 0] ; global  [set vR] ; upvar 0 [set vR] _B
            if  ![string match EXPAND $_Op]  {
               if { $lB >= 1 } {
 	          set aSkip 1
                  set Rem [expr $lA % $lB]
                  if { $Rem != 0 } { 
                     puts stderr "Unmatched arrays. A size is $lA, B is $lB"
                     exit
                  } else { set Reps [expr $lA / $lB] }
               } else { set aSkip 0 ; set Reps 1 }
            } else { set Reps 1 }
	 }
      }
 
# YOU always need to check to see if _Vb  is a constant or a variable. Other
#   things to consider is there can be one input A and multiple input B,
#   one input B and multiple input A or only one input A for each input B.
#  

      switch -exact -- $_Op {
         + -
         - -
         * -
         / {
	    switch -exact -- $vT {
	       AV_BV {
                  if { $nA > $nB } { set EnD $nA } else { set EnD $nB }
                  for { set _N 0 } { $_N < $EnD } { incr _N } {
	             set J [expr $_N % $nA]
	             set K [expr $_N % $nB]

                     set vR [lindex $aN $J] ; global  [set vR] 
                     upvar 0 [set vR] _A
                     set vR [lindex $cN $_N] ; global [set vR]
                     upvar 0 [set vR] _C
                     set _C(Dim) $_A(Dim)
	             APxferGInfo _A _C

                     APbadGrid FLAG $lA _A StatusA

                     set vR  [lindex $bN $K]
                     global [set vR] ; upvar 0  [set vR] _B
                     APbadGrid AFLAG $lA,$lB _B StatusA
		     set aBeg 0
		     for { set L 0 } { $L < $Reps } { incr L } {
                        TUarrayMath _A $_Op _B  _C $lB $aBeg 0 $aBeg
		        incr aBeg $lB
                     }
                     APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
                  }		     
               }
	       AV_BC {
                  for { set _N 0 } { $_N < $nA } { incr _N } {
                     set vR [lindex $aN $_N] ; global  [set vR] 
                     upvar 0 [set vR] _A

                     set vR [lindex $cN $_N] ; global [set vR]
                     upvar 0 [set vR] _C
                     set _C(Dim) $_A(Dim)

	             APxferGInfo _A _C

                     APbadGrid FLAG $lA _A StatusA

                     set vR  [lindex $bN 0]
                     TUarrayMath _A $_Op $vR _C $lA
                     APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
                  } 
	       }
	       AC_BV {
                  for { set _N 0 } { $_N < $nB } { incr _N } {
                     set vR [lindex $bN $_N] ; global  [set vR] 
                     upvar 0 [set vR] _B

                     set vR [lindex $cN $_N] ; global [set vR]
                     upvar 0 [set vR] _C
                     set _C(Dim) $_B(Dim)

	             APxferGInfo _B _C

                     APbadGrid FLAG $lB _B StatusB

                     set vR  [lindex $aN 0]
                     for { set J 0 } { $J < $lB } { incr J } {
		        set _C($J) [expr $vR $_Op $_B($J)]
		     }
                     APbadGrid RESET $lB _C StatusB 0 $apANS(BaD)
                  } 
	       }
	       AC_BC {
                  set vR [lindex $cN $_N] ; global [set vR]
                  upvar 0 [set vR] _C
                  set _C(Dim) [list 1 1]

                  set vA  [lindex $aN 0]
                  set vB  [lindex $bN 0]
		  set _C(0) [expr $vA $_Op $vB]
               }
            }
         }
         ABS { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) < 0.0 } {
	             set _C($J) [expr -$_A($J)]
	          } else { set _C($J) $_A($J) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
	 ACOS -
	 ASIN -
         ATAN  -
         ATAND -
         ASIND -
         ACOSD - 
	 COS   -
	 COSD  -
	 SIN   -
	 SIND  {
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               TUarrayMath _A $_Op _A _C $lA
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         AVG - 
         SUM { 
            set vR [lindex $aN 0] ; global [set vR] ; upvar 0 [set vR] _A

            set vR [lindex $cN 0] ; global [set vR] ; upvar 0 [set vR] _C
            set _C(Dim) $_A(Dim)
	    APxferGInfo _A _C

	    for { set J 0 } { $J < $lA } { incr J } { set _C($J) $_A($J) }
            APbadGrid FLAG $lA _C StatusC

            for { set J 1 } { $J < $nA } { incr J } {
               set vR [lindex $aN $J]
               global  [set vR]
               upvar 0 [set vR] _A
               APbadGrid FLAG $lA _A StatusA
               TUarrayMath _A + _C _C $lA
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }

            for { set J 0 } { $J < $nB } { incr J } {
               set vR  [lindex $bN $J]
	       if [lindex $bType $J] {
                  TUarrayMath _C + $vR _C $lA
               } else {
                  global [set vR] ; upvar 0  [set vR] _B
                  APbadGrid AFLAG $lA,$lB _B StatusA
	          set aBeg 0
	          for { set L 0 } { $L < $Reps } { incr L } {
                     TUarrayMath _C + _B  _C $lB $aBeg 0 $aBeg
	             incr aBeg $lB
                  }
                  APbadGrid RESET $lA _C StatusB 0 $apANS(BaD)
               }
            }

	    if [string match AVG $_Op] {
	       set nV [expr double($nA + $nB)]
               TUarrayMath _C / $nV _C $lA
	    }

            APbadGrid RESET $lA _C StatusC 0 $apANS(BaD)
         }
         DETREND { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
	       set AvG 0.0
	       set tE 0
               for { set J 0 } { $J < $lA } { incr J } {
	          if $StatusA($J) {
	             incr tE
		     set AvG [expr $AvG + $_A($J)]
	          }
	       }
	       if { $tE > 0 } { set AvG [expr $AvG / double($tE)] }

               TUarrayMath _A - $AvG _C $lA
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         SQRT { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) >= 0.0 } {
	             set _C($J) [expr sqrt($_A($J))]
	          } else { set _C($J) $apANS(BaD) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         LOG10 { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) >= 0.0 } {
	             set _C($J) [expr log10($_A($J))]
	          } else { set _C($J) $apANS(BaD) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         LOGE { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          if { $_A($J) >= 0.0 } {
	             set _C($J) [expr log($_A($J))]
	          } else { set _C($J) $apANS(BaD) }
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         EXP { 
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr exp($_A($J))]
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
	 EXPAND {
	    set pN -1
            for { set _N 0 } { $_N < $nMax } { incr _N } {

	       set _iA [expr $_N % $nA]
	       set _iB [expr $_N % $nB]
	       set _iC [expr $_N % $nC]

               set vR [lindex $aN $_iA] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $bN $_iB] ; global  [set vR]
               upvar 0 [set vR] _B

               set vR [lindex $cN $_iC] ; global [set vR]
               upvar 0 [set vR] _C

               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
	       set nP [APexpandFit $pN _B _A Dum Dum _C 1]
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
	 }
         POW { 
            set fV  [lindex $bN 0]
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr pow($fV, $_A($J))]
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         FMOD { 

# FMOD of an array.  The value to fmod do is in bN.  There should
#  only be a single constant value.

           set fV  [lindex $bN 0]

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr fmod($_A($J), $fV)]
	       }
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
         }
         NORM { 

# NEED to find the absolute maximum of all the input variables

            set NorM $apANS(BaD)
            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

	       set rV [TUdataMxMn _A $lA <>]
	       set MiN $_A([lindex $rV 0])
	       if { $MiN < 0.0 } { set MiN [expr -$MiN] }
	       if { $MiN > $NorM } { set NorM $MiN }
	       set MaX $_A([lindex $rV 1])
	       if { $MaX < 0.0 } { set MaX [expr -$MaX] }
	       if { $MaX > $NorM } { set NorM $MaX }
            }

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) $_A(Dim)
	       APxferGInfo _A _C

               APbadGrid FLAG $lA _A StatusA
               for { set J 0 } { $J < $lA } { incr J } {
	          set _C($J) [expr $_A($J) / $NorM ]
	       }
	       set _C(Norm) $NorM
               APbadGrid RESET $lA _C StatusA 0 $apANS(BaD)
            }
	 }
         MNMX -
         MNMXLOG {
	    if [string match MXMNLOG $_Op] {
	       set BaDL 0.0
            } else { set BaDL $apANS(BaDL) }

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global  [set vR]
               upvar 0 [set vR] _C

# Set up a temporary array of the input data
 
               for { set _M 0 } { $_M < $lA } { incr _M } {
	          set _TmP($_M) $_A($_M)
               }

               APbadGrid CANDF $lA _TmP StatusA 0 $apANS(BaD)
	       set rV [TUdataMxMn _TmP $lA <> $BaDL $apANS(BaDU)]
	       set _C(0) $_TmP([lindex $rV 0])
	       set _C(1) $_TmP([lindex $rV 1])
	       set _C(aType) MXMN
	       set _C(Dim) [list 2 0]
            }
	 }
         TOTALA -
         TOTALS { 

# COMPUTE the total or average values of all of the input values.  
 
            set LBaD $apANS(BaDL)
            set UBaD $apANS(BaDU)

            for { set _N 0 } { $_N < $nA } { incr _N } {
               set vR [lindex $aN $_N] ; global  [set vR]
               upvar 0 [set vR] _A

               set vR [lindex $cN $_N] ; global [set vR]
               upvar 0 [set vR] _C
               set _C(Dim) [list 1 1]

               set _C(0) 0.0
	       set nE 0

	       for { set K 0 } { $K < $lA } { incr K } { 
	          if { ($_A($K) > $LBaD) &&  ($_A($K) < $UBaD) } {
	             incr nE
		     set _C(0) [expr $_C(0) + $_A($K)] 
                  }
               }

               set _C(nE) $nE

	       if [string match TOTALA $_Op] {
	          if { $nE > 0 } {
	             set _C(0) [expr $_C(0) / double($nE)]
	          } else { set _C(0) 0.0 }
               }
            }
         }
      }
   }
}
