package provide UDFAnalysis 1.0

# Draws a line in one of the plots  

proc APsolveGLine { gD } {
   global apANS env Prefs WinInfo PltInfo GphInfo

   APkeepTabs "OBJECT $gD : LINE"

# THIS is the text window for this function definition

   set W .apGOBJ$gD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($gD,gObj)) 0]
      eval $GuI $gD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s" pID X(0) X(1) Y(0) Y(1) lC lW lS

# FROM the plot iD get the plot number, window number and the index into 
#   the plot definitions where the plot information is contained.

      set pS [lindex $apANS($pID) 0]
      set pN $apANS($pS,Col).$apANS($pS,Row)
      set wN $PltInfo($pN,wN)

# GET the X inputs into proper units.  X1 is either SPAN if we span the plot
# in X or a value. X2 has the option of being X1 if it is the same as X1.

      if [string match X1 $X(1)] { set X(1) $X(0) }

# IF this is a time based plot we need to convert the X inputs which should
#   be in the format YYYY DOY HH MM SS.FSEC to a proper X value

      if [string match YES $apANS($pS,tBased)] {
         for { set J 0 ; set K 0 } { $J < 2 } { incr J ; incr K 3 } {
            if ![string match SPAN $X($J)] { 
               set T [split $X($J) ":"]
	       set H [lindex $T 2] ; set M [lindex $T 3] ; set S [lindex $T 4]
	       set xS [expr 3600 * $H + 60 * $M + $S]
	       set xMs [expr int(1000 * $xS)]
	       set pB [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
	       set xB [list [lindex $T 0] [lindex $T 1] $xMs]
	       set X($J) [TUtimeConv $pB $xB 0 apANS(tBase)]
            } else { set X($J) $WinInfo($wN,p$K) }
         }
      }

# GET the Y inputs into proper units.  Y1 is either SPAN if we span the plot
# in Y or a value. Y2 has the option of being Y1 if it is the same as Y1.

      if [string match Y1 $Y(1)] { set Y(1) $Y(0) }
      if [string match SPAN $Y(0)] { set Y(0) $WinInfo($wN,p1) }
      if [string match SPAN $Y(1)] { set Y(1) $WinInfo($wN,p4) }

      set tColor $GphInfo(lColor)
      set tStyle $GphInfo(lStyle)
      set tWidth $GphInfo(lWidth)
      set tClip  $WinInfo($wN,Clip)

   
      WinClip $wN AT  
      LineStyle $lW $lS
      PlotColor HOLD $lC OFF
      Line $wN $X(0) $Y(0) 0.0 $X(1) $Y(1) 0.0
      LineStyle $tWidth $tStyle
      PlotColor HOLD $tColor OFF
      WinClip $wN $tClip  
   }
}
