# CONVERSION operations
#

package provide UDFAnalysis 1.0

proc APsolveConv { fD } {
   global apANS env Prefs RtoD

   APkeepTabs "STEP $fD : CONVERSION"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the conversion definitions

   for { set I 0 } { $I < $nF } { incr I } {

# GET the conversion definition
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s" _vI _cV _rV _cP _vO

# GET the input and output varaible(s)

      set iNames [lindex [APgetVNames $_vI] 0]
      set nI [llength $iNames]
      set oNames [lindex [APgetVNames $_vO] 0]
      set nO [llength $oNames]

# IF the number of input and output variables don't match then skip line.

      if { $nI != $nO } { continue }

# SET math operation to use in the conversion

      if [string match NO $_cP] { set MoP * } else { set MoP / }

# Separate conversions by multi-step or simple multiplicative factor.  This
#   will save a lot of lines of code.

# Look for complex conversions first

      switch -exact -- $_cV {
         Phi360->Phi180 {
	    if [string match NO $_rV] {
               for { set J 0 } { $J < $nI } { incr J } { 
                  set vA [lindex $iNames $J]
                  global  [set vA] ; upvar 0 [set vA] _V1
	          set nE [lindex $_V1(Dim) 0]

                  set vB [lindex $oNames $J]
                  global  [set vB] ; upvar 0 [set vB] _V2

                  APbadGrid FLAG $nE _V1 StatusA
                  for { set K 0 } { $K < $nE } { incr K } {
		     if {$_V1($K) > 180.0 } {
		        set _V2($K) [expr $_V1($K) - 360.0]
                     } else { set _V2($K) $_V1($K) }
		  }
                  APbadGrid RESET $nE _V2 StatusA 0 $apANS(BaD)
	          set _V2(Dim) $_V1(Dim)
	          APxferGInfo _V1 _V2
               }		   
	    } else {
               for { set J 0 } { $J < $nI } { incr J } { 
                  set vA [lindex $iNames $J]
                  global  [set vA] ; upvar 0 [set vA] _V1
	          set nE [lindex $_V1(Dim) 0]

                  set vB [lindex $oNames $J]
                  global  [set vB] ; upvar 0 [set vB] _V2

                  APbadGrid FLAG $nE _V1 StatusA
                  for { set K 0 } { $K < $nE } { incr K } {
		     set _V2($K) [expr fmod($_V1($K) + 360.0, 360.0)]
		  }
                  APbadGrid RESET $nE _V2 StatusA 0 $apANS(BaD)
	          set _V2(Dim) $_V1(Dim)
	          APxferGInfo _V1 _V2
               }		   
	    }
         }

         Theta180->Theta90 {
            for { set J 0 } { $J < $nI } { incr J } { 
               set vA [lindex $iNames $J]
               global  [set vA] ; upvar 0 [set vA] _V1
	       set nE [lindex $_V1(Dim) 0]

               set vB [lindex $oNames $J]
               global  [set vB] ; upvar 0 [set vB] _V2

               APbadGrid FLAG $nE _V1 StatusA
               for { set K 0 } { $K < $nE } { incr K } {
	          set _V2($K) [expr 90.0 - $_V1($K)]
	       }
               APbadGrid RESET $nE _V2 StatusA 0 $apANS(BaD)
	       set _V2(Dim) $_V1(Dim)
	       APxferGInfo _V1 _V2
	    }
         }
      }

# NOW the straight multiplicative

      set F Unknown
      switch -exact -- $_cV {
         cm->m {
	    if [string match NO $_rV] { set F 1.0e-2 } else { set F 1.0e2 }
         }
         cm->km {
	    if [string match NO $_rV] { set F 1.0e-5 } else { set F 1.0e5 }
         }
         m->km {
	    if [string match NO $_rV] { set F 1.0e-3 } else { set F 1.0e3 }
         }
         cm2->m2 {
	    if [string match NO $_rV] { set F 1.0e-4 } else { set F 1.0e4 }
         }
         cm2->km2 {
	    if [string match NO $_rV] { set F 1.0e-10 } else { set F 1.0e10 }
         }
         m2->km2 {
	    if [string match NO $_rV] { set F 1.0e-6 } else { set F 1.0e6 }
         }
         cm3->m3 {
	    if [string match NO $_rV] { set F 1.0e-6 } else { set F 1.0e6 }
         }
         cm3->km3 {
	    if [string match NO $_rV] { set F 1.0e-15 } else { set F 1.0e15 }
         }
         m3->km3 {
	    if [string match NO $_rV] { set F 1.0e-9 } else { set F 1.0e9 }
         }
         deg->rad {
	    if [string match NO $_rV] { 
	        set F [expr 1.0 / $RtoD]
	    } else { set F $RtoD }
         }
         eV->kelvin {
	    if [string match NO $_rV] { 
	        set F 1.16045e4 
            } else { set F 8.617347e-5 }
         }
         eV->ergs {
	    if [string match NO $_rV] { 
	        set F 1.602e-12 
            } else { set F 6.242e11 }
         }
         eV->joules {
	    if [string match NO $_rV] { 
	        set F 1.602e-19 
            } else { set F 6.242e18 }
         }
         nT->gauss {
	    if [string match NO $_rV] { 
	        set F 1.0e-5 
            } else { set F 1.0e5 }
         }
         nT->T {
	    if [string match NO $_rV] { 
	        set F 1.0e-9 
            } else { set F 1.0e9 }
         }
      }

      if ![string match Unknown $F] {
         for { set J 0 } { $J < $nI } { incr J } { 
            set vA [lindex $iNames $J]
            global  [set vA] ; upvar 0 [set vA] _V1
	    set nE [lindex $_V1(Dim) 0]

            set vB [lindex $oNames $J]
            global  [set vB] ; upvar 0 [set vB] _V2

            APbadGrid FLAG $nE _V1 StatusA
            for { set K 0 } { $K < $nE } { incr K } {
	       set _V2($K) [expr $_V1($K) $MoP $F]
	    }
            APbadGrid RESET $nE _V2 StatusA 0 $apANS(BaD)

	    set _V2(Dim) $_V1(Dim)
	    APxferGInfo _V1 _V2
	 }
      }
   }
}
