# THIS routine reads generic ASCII file.  User is responsible for describing
#    the file format.
#
# FOR time based data procedure assumes that each line contains a time 
#   taq which provides the year, dayofyear (or month day), hour, minute, 
#   second, and possibly  millisecond.  There can be a beginning and 
#   ending time tag.  The beginning times should have been labeled bY, bD, 
#   (bMo bD), bH, bM, bS, bMs and if there is an ending time eY, eD, 
#   (eMo, eD), eH, eM, eS, and eMs.  As stated above neither eMs nor bMs 
#   need be used.  Also milliseconds may be included as fractional seconds.
#
#   Variables are assumed to start with _

package provide UDFAnalysis 1.0

proc APreadGeneric { vD } {
   global apANS 

   APkeepTabs "READING [file tail $apANS($vD,aName)]" 

# SET up the read command(s) 
 
   set nLines [APasciiFVR $vD rCmd rRep rAdv rLine]

# OPEN the data file

   if [catch {open $apANS($vD,aName) r} fd ] { 
      puts stderr "CAN'T OPEN FILE $apANS($vD,aName) "
      return -1
   } 

# READ any header information and stop just before the start of the data.  If
#   DataAfter is _FirstLine_ then there is no header information and if its
#   a 0 length string begin after the first blank line.

   if ![string match _FirstLine_ $apANS($vD,DataAfter)] {
      if { [string length $apANS($vD,DataAfter)] > 0 } {
         set StoP 0
         while { !$StoP } {
            gets $fd LiNe
            set LiNe [string trim $LiNe]
	    set fS [expr [string first " " $LiNe] - 1]
	    if { $fS >= 0 } { set LiNe [string range $LiNe 0 $fS] }
            set StoP [string match $apANS($vD,DataAfter) $LiNe]
         }
      } else {
         set StoP 1
         while { $StoP > 0 } {
            gets $fd LiNe
            set LiNe [string trim $LiNe]
            set StoP [string length $LiNe]
         }
      }
   }

# FILE can contain data which is either time based or not.  They
#   process differently

   if [string match YES $apANS($vD,tM)] { 
       APasciiTBase $vD $fd $nLines rCmd rRep rAdv rLine
   } else { APasciiNTBase $vD $fd $nLines rCmd rRep rAdv rLine }
}
