package provide UDFAnalysis 1.0

proc APpreSets { } {
   global apANS 

# COMPUTE the beginning and ending milliseconds of the input time range
#   for both data and plots

   set bMs [expr 3600 * $apANS(begHr) + 60 * $apANS(begMn) + $apANS(begSc)]
   set apANS(begMs) [expr int(1000 * $bMs)]
   set eMs [expr 3600 * $apANS(endHr) + 60 * $apANS(endMn) + $apANS(endSc)]
   set apANS(endMs) [expr int(1000 * $eMs)]

   set bMs [expr 3600 * $apANS(PbegHr) + 60 * $apANS(PbegMn) + $apANS(PbegSc)]
   set apANS(PbegMs) [expr int(1000 * $bMs)]
   set eMs [expr 3600 * $apANS(PendHr) + 60 * $apANS(PendMn) + $apANS(PendSc)]
   set apANS(PendMs) [expr int(1000 * $eMs)]

# Determine the time base
 
   set B -1
   set T1 [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
   set T2 [list $apANS(endYr) $apANS(endDy) $apANS(endMs) 0]
   set A [TUtimeConv $T1 $T2 0 B]
   set apANS(tBase) $B

# Check the sources.  If there is a UDF source then we need to initiialize
#    the UDF.  At the same time we should check that at least there is
#    a full PMEIV definition any UDF source.

   set UDF 0
   set PV [list P M E I V]

   if ![winfo exists .apVAR] { APvarGUI 1 }
   set W .apVAR.body.list

   set nS [$W index end]
   for { set I 0 } { $I < $nS } { incr I } {
      set sDef [$W get $I]
      scan $sDef "%d" sN
      if [string match UDF $apANS($sN,Src)] { 
	 set UDF 1
	 set iD UD$sN
	 for { set J 0 } { $J < 5 } { incr J } {
	    set ChK [string trim $apANS($iD,[lindex $PV $J])]
	    if { [string length $ChK] == 0 } { 
	       puts stderr "INCOMPLETE PMEIV for SOURCE $sN"
	       exit 
	    }
         }
      }
   }
}
