package provide UDFAnalysis 1.0

proc APplots2DXY { pD Var pFmt } {
   global apANS GphInfo PltInfo

   upvar $Var vN

# SET the plot number and the index into the plot definitions where the plot
#   information is contained.

   set P $apANS($pD,pID)
   set pS [lindex $apANS($P) 0]
   set _pN $apANS($pS,Col).$apANS($pS,Row)

# SET the plot axes  

   set _aX $apANS($pD,xActive) 
   set _aY $apANS($pD,yActive)

# CHECK the X variable to see if its plottable.  If not then try and build
#   the plot variables from it. _Da and _Db are dummy arrays.  Since we
#   know the plot being produced is 2D no info will be returned in those
#   variables.

   set nV [APbuildVar $pD $vN(0) _X _Da _Db _Y]

   set nX [lindex $nV 0]
   if { $nX < 0 } { return }

   if { $nX == 0 } {

# IF nX is zero then the variables are plottable as they are input.  In this
#   case assign them pointers and if they are time based then make sure that
#   we get the offsets into the plot times.

      set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _X
      set n0 [lindex $_X(Dim) 0]
      set n1 [lindex $_X(Dim) 1]
      if { $n1 > 1 } { set nX $n1 } else { set nX $n0 }
      set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Y
    
      set tB1 0 ; set tB2 0
      if [info exist _X(gItB)] { set tB1 [string match YES $_X(gItB)] }
      if [info exist _Y(gItB)] { set tB2 [string match YES $_Y(gItB)] }
      if { $tB1 && $tB2 } {
          APtimeSpan _X BeG EnD
      } else { set BeG 0 ; set EnD [expr $nX - 1] }
   } else { set BeG 0 ; set EnD [expr $nX - 1] }

# SET omission conditions.  These essentially nuke data which is <= 0
#   on log based axes and will remove any undefined data within the
#   varaible grid.

   set xC < ; set yC < 
   set _xV $apANS(BaDL) ; set _yV $apANS(BaDL) 

   if [string match Xb $_aX] {
      if [string match LOG $apANS($pS,xbSca)] { set xC <= ; set _xV 0. }
   } else { if [string match LOG $apANS($pS,xtSca)] { set xC <= ; set _xV 0. } }

   if [string match Yl $_aY] {
      if [string match LOG $apANS($pS,ylSca)] { set yC <= ; set _yV 0. }
   } else { if [string match LOG $apANS($pS,yrSca)] { set yC <= ; set _yV 0. } }

# GET the plot window and make it the current window

   set wN $PltInfo($_pN,wN)
   set GphInfo(curWin) $wN

# SET the plot line color, width and style keeping the old ones so that we
#   can reset to those values at the end

   if [info exists GphInfo($apANS($pD,lColor))] {
      set lC $GphInfo($apANS($pD,lColor))
   } else { set lC $apANS($pD,lColor) }

   if [info exists GphInfo($apANS($pD,sColor))] {
      set sC $GphInfo($apANS($pD,sColor))
   } else { set sC $apANS($pD,sColor) }

   set oW $GphInfo(lWidth)
   set oS $GphInfo(lStyle)
   set GphInfo(lWidth) $apANS($pD,lWidth)
   set GphInfo(lStyle) $apANS($pD,lStyle)

# NOW plot the data based on the type of plot requested

   switch -exact -- $apANS($pD,pType) {
      LINE {
         set pOp [list 2D $lC ]
         set eOp [list $xC $_xV $yC $_yV]
         PLTlinePlot $wN $_aX $_aY _X _Y Dum Dum $BeG $EnD $pOp $eOp
      }
      POINT {
         set SyM [APucodeParse $apANS($pD,Sym)]
         set pOp [list $pFmt $sC $apANS($pD,sFont) $apANS($pD,sSize) $SyM] 
         set eOp [list < $apANS(BaDL) $yC $_yV]
         PLTscatterPlot $wN $_aX $_aY _X _Y Dum Dum $BeG $EnD $pOp "" $eOp
      }
      BARS {
         set pOp [list 2D $lC ]
         set eOp [list $xC $_xV $yC $_yV]
         PLThistogramPlot $wN $_aX $_aY _X _Y Dum $BeG $EnD $pOp $eOp
      }
      CERROR {
         set pOp [list CROSS $lC ]
         set eOp [list $xC $_xV $yC $_yV]
 
	 if { [llength $vN(0)] > 1 } {
	    set vX [lindex $vN(0) 1] ; global [set vX] ; upvar 0 [set vX] _Xe
         } else { 
	    set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _Xe
         }
 
	 if { [llength $vN(1)] > 1 } {
	    set vY [lindex $vN(1) 1] ; global [set vY] ; upvar 0 [set vY] _Ye
         } else {
	    set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Ye
         }

         PLTerrorPlot $wN $_aX $_aY _X _Xe _Y _Ye "" $BeG $EnD $pOp $eOp
      }
      BERROR {
         set pOp [list BOX $lC ]
         set eOp [list $xC $_xV $yC $_yV]
 
	 if { [llength $vN(0)] > 1 } {
	    set vX [lindex $vN(0) 1] ; global [set vX] ; upvar 0 [set vX] _Xe
         } else {
	    set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _Xe
         }
 
	 if { [llength $vN(1)] > 1 } {
	    set vY [lindex $vN(1) 1] ; global [set vY] ; upvar 0 [set vY] _Ye
         } else { 
	    set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Ye
         }
         
         PLTerrorPlot $wN $_aX $_aY _X _Xe _Y _Ye "" $BeG $EnD $pOp $eOp
      }
   }

# RESET possibly changed setting

   set GphInfo(lWidth) $oW
   set GphInfo(lStyle) $oS

   update
}
