package provide UDFAnalysis 1.0

proc APplotVar { pD } {
   global apANS GphInfo PltInfo

# SET the plot number and the index into the plot definitions where the plot
#   information is contained.

   set P $apANS($pD,pID)
   set pS [lindex $apANS($P) 0]
   set pN $apANS($pS,Col).$apANS($pS,Row)

# SET the plot axes  

   set aX $apANS($pD,xActive) 
   set aY $apANS($pD,yActive)

# FIND out what variables we have to plot and how many.  Initialize their
#   array lengths to 0

   set vName(0) [lindex [APgetVNames $apANS($pD,VarX)] 0]
   set vName(1) [lindex [APgetVNames $apANS($pD,VarY)] 0]
   set vName(2) [lindex [APgetVNames $apANS($pD,VarZ)] 0]
   set vName(3) [lindex [APgetVNames $apANS($pD,VarI)] 0]

# Determine which variables are being plotted.
# IF the x varaible is a non-plottable variable and can be expanded into
#    a set of plottable information get the dimensions of the plot.

   set pDim [APgetDim vName]

# WITH this information we should be able figure out how to put up the
#    the plot.  Start with the time based plots.
#
#   1. 2D time based plot only have a Y variable.  The X or time
#      variable will be created internally

   if [string match YES $apANS($pS,tBased)] {
      switch -exact -- $pDim {
         1100 { APplots2DTime $pD vName }
         1101 { APplots3DTime $pD vName }
      }
   } else {
      switch -exact -- $pDim {
         1100 { APplots2DXY $pD vName 2D  }
         1101 { APplots3DXY $pD vName 2DC }
         1110 { APplots3DXY $pD vName 3D  }
         1111 { APplots3DXY $pD vName 3DC }
      }
   }
}
