package provide UDFAnalysis 1.0

proc APplotFinish { } {
   global apANS GphInfo PltInfo DevInfo WinInfo

   if ![winfo exists .apLAYOUT] { APlayoutGUI 1 }
   set W .apLAYOUT.body.list
   set nP [$W index end]
   if { $nP == 0 } { return }
   for { set I 0 } { $I < $nP } { incr I } {
      scan [$W get $I] "%d" sN
      set P $apANS($sN,piD)
      if [string match _DP_ $P] { continue }

      set pN $apANS($sN,Col).$apANS($sN,Row)
      set wN $PltInfo($pN,wN)
      if { $WinInfo($wN,Dimen) == 2 } {
         APplot2DAxes $sN
         if [string match YES $apANS($sN,cBShow)] { APoutputCB $sN }
      } else { APplot3DAxes $sN }
   } 

# PUT up any defined labels for the various parameters.  Need to note the
#   the following.  Labels output with a plot id of _PW_ are attached to
#   the parent window and their X and Y offests give the label position.
#   This was probably the result manually moving a label.  

   if { $WinInfo($wN,Dimen) == 2 } {
      set ScA [list LINEAR LOG]

      if ![winfo exists .apLABEL] { APlabelGUI 1 }
      set W .apLABEL.body.list
      set nL [$W index end]
      for { set K 0 } { $K < $nL } { incr K } {
         scan [$W get $K] "%d" sN

# SET the label tag

	 set GphInfo(tag) LAB_$sN

# SET up the text properties used in outputting the label

         TextProp $apANS($sN,Lsize) HOLD $apANS($sN,Lbold)

# LABEL position, justification, agnle, and color

	 set xO   $apANS($sN,Lxoff)
	 set yO   $apANS($sN,Lyoff)
	 set Just $apANS($sN,Ljust)

	 if [info exists GphInfo($apANS($sN,Lcol))] {
	    set C $GphInfo($apANS($sN,Lcol))
         } else { set C $apANS($sN,Lcol) }

         set aX $apANS($sN,Laxis)

# THIS is the plot ID

	 set PiD $apANS($sN,Lpid)

	 if [string match _PW_ $PiD] {
	    if [string match X [string index $aX 0]] { 
	       set LaB [APgenLab $sN]
            } else { set LaB [APgenLab $sN 1] }
	    TexT A $xO $yO 0.0  $Just $LaB $C "0.0 0.0 0.0"
	 } else {
	    set LaB [APgenLab $sN]
	    set pS [lindex $apANS($PiD) 0]
	    set pN $apANS($pS,Col).$apANS($pS,Row)

	    set xbs [lindex $ScA $WinInfo($pN,pa0)]
	    set xts [lindex $ScA $WinInfo($pN,pa1)]
	    set yls [lindex $ScA $WinInfo($pN,sa0)]
	    set yrs [lindex $ScA $WinInfo($pN,sa1)]

	    SetAxis $pN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD \
	                                            LINEAR LINEAR HOLD 1

            set GphInfo(curWin) $PltInfo($pN,wN)
            set cS(Xb) [GPHtextLen 2 X]
            set cS(Yl) [GPHtextLen 2 Y]
	    if {$WinInfo($pN,pp0) > $WinInfo($pN,pp3) } {
	       set SgN(Xb) -
            } else { set SgN(Xb) + }
	    if {$WinInfo($pN,pp1) > $WinInfo($pN,pp4) } {
	       set SgN(Yl) -
            } else { set SgN(Yl) + }

            SetAxis $pN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD \
	                                              LINEAR LINEAR HOLD 1

            set cS(Xt) [GPHtextLen 2 X]
            set cS(Yr) [GPHtextLen 2 Y]
	    if {$WinInfo($pN,sp0) > $WinInfo($pN,sp3) } {
	       set SgN(Xt) -
            } else { set SgN(Xt) + }
	    if {$WinInfo($pN,sp1) > $WinInfo($pN,sp4) } {
	       set SgN(Yr) -
            } else { set SgN(Yr) + }

            set GphInfo(curWin) $pN
            set Loc  $apANS($sN,Lpos)

	    if [string match Y [string index $aX 0]] {
	       set Level $xO
	       set Pos [expr [PLTlabPos $pN $aX $Loc] $SgN($aX) $yO * $cS($aX)]
	    } else {
	       set Level $yO
	       set Pos [expr [PLTlabPos $pN $aX $Loc] $SgN($aX) $xO * $cS($aX)]
	    }

            PLTinfoChg $pN $aX NUMBERS TCOLOR $C
            PLTinfoChg $pN $aX NUMBERS TSIZE $apANS($sN,Lsize)
            PLTinfoChg $pN $aX NUMBERS TPOSITION $apANS($sN,Lloc)
            PLTinfoChg $pN $aX NUMBERS TANGLE "$apANS($sN,Lang) 0.0 0.0"

            PLTaxisRec $pN $aX NONE AXIS $Level $Pos $Just $LaB 
            PLTinfoChg $pN $aX NUMBERS TPOSITION OUTSIDE
            PLTinfoChg $pN $aX NUMBERS TANGLE "0.0 0.0 0.0"

 	    SetAxis $pN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD $xbs $yls HOLD 1
 	    SetAxis $pN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD $xts $yrs HOLD 1
         }
      }
   }

   if { [string length $apANS(tLab)] > 0 } {
      set X [expr ($WinInfo(A,p3) + 1) / 2.0 ]
      set Y [expr $WinInfo(A,p4) + 1 - 1.5 * $apANS(xC12)]
      TextProp $apANS(tLabS) HOLD $apANS(tLabB) 
      if [info exists GphInfo($apANS(tLabC))] {
         set C $GphInfo($apANS(tLabC))
      } else { set C $apANS(tLabC) }
      TexT A $X $Y 0.0 center $apANS(tLab) $C
      TextProp 12 HOLD OFF
   }

   APpscriptOut

   ShowScreen

   set GphInfo(tag) ""
}
