# THIS is the main menu in the UDF analysis package

package provide UDFAnalysis 1.0

proc APmainGUI {  } {
  global apANS env Prefs

# READ in the preference file

   GUIprefsRead

# SET up some font definitions
 
   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set IFonT [list "" "" normal italic]
   set BFonT [list "" $bSize bold]

# THESE are the button labels
 
   set BLab [ list "TIME DEFINITION" "VARIABLE DEFINITIONS" FUNCTIONS \
                    "PLOT SETUP" "PLOT LAYOUT" "PLOT DEFINITIONS" \
		    "PLOT LABELS" "OUTPUT POSTSCRIPT" "GRAPHICS OBJECT" \
		    "PREFERENCES" ]

# THESE are the button function calls
 
   set BFunc [ list APtimeGUI APvarGUI APfuncGUI APpsetGUI APlayoutGUI \
                    APplotGUI APlabelGUI APpscriptGUI APgobjGUI APprefsGUI ] 

# SUB window
 
   set BSWin [ list time var func pset layout plot label pscript gobj prefs ] 

# THIS is the number of column of buttons
 
   set BCol $apANS(P,MCols)   

# FIND the maximum button label size
 
   set MxBLab 0
   set nB [llength $BLab]
   for { set I 0 } { $I < $nB } { incr I } {
      set lSz [string length [lindex $BLab $I]]
      if { $lSz > $MxBLab } { set MxBLab $lSz }
   }

# SET up the menu if it doesn't already exist
 
   if ![winfo exists .apTOP] {

      . configure -bg $Prefs(FBgCol)

      set Wa .apTOP
      set Wb .apMENU
      set Wc .apBODY

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both
      GUIFrame $Wc -1 pack|left||both

      GUIFrame $Wa.a -1 pack|left||both
      GUIFrame $Wa.b -1 pack|left||both
      GUIFrame $Wa.c -1 pack|right||both
      
      GUIbuttonPush $Wa.a.run  RUN  pack|left "APrunIt" 6
      GUILabel $Wa.b.acta "" c pack|top 12 36
      GUILabel $Wa.b.actb "" c pack|top 12 36
      GUIbuttonPush $Wa.c.quit QUIT pack|right "exit"  6

      APkeepTabs "MENU FILL IN"

      set R 0
      GUIblankRow $Wb $R 1.0
      incr R

      GUIbuttonPush $Wb.load  LOAD  grid|$R|0|e "APreadMenu"
      GUIboxEntry $Wb.im grid|$R|1|news 45 apANS(miFile)
      GUIbuttonPush $Wb.bim Browse grid|$R|2 "APmenuReflect" 6

      incr R
      GUIbuttonPush $Wb.save  SAVE  grid|$R|0|e "APsaveMenu"
      GUIboxEntry $Wb.sm grid|$R|1|news 45 apANS(moFile) 
      GUIbuttonPush $Wb.bsm Browse grid|$R|2 \
                                  {set apANS(moFile) [tk_getOpenFile]} 6

# IF the input and save menu names are empty initialize them.
 
      if { [string length $apANS(miFile)] == 0 } {
         set apANS(miFile) "Input File" 
	 $Wb.im configure -fg #0000FF
      }

      if { [string length $apANS(moFile)] == 0 } { 
         set apANS(moFile) "Save File" 
	 $Wb.sm configure -fg #0000FF
      }
 
# BIND the input and save menu boxes to clear with a keypress and to change
#    the text color to black.  This is only done if the current fg color is
#    blue.  Do the same for the Browse button
 
      bind $Wb.im <Any-Key> {
        if [string match #0000FF [%W cget -fg]] {
           %W delete 0 end
	   %W configure -fg #000000
	}
      }
      bind $Wb.bim <ButtonPress> {
        if [string match #0000FF [.apMENU.im cget -fg]] {
	   .apMENU.im configure -fg #000000
	}
      }

      bind $Wb.im <Any-Key> {
        if [string match #0000FF [%W cget -fg]] {
           %W delete 0 end
	   %W configure -fg #000000
	}
      }
      bind $Wb.bsm <ButtonPress> {
        if [string match #0000FF [.apMENU.sm cget -fg]] {
	   .apMENU.sm configure -fg #000000
	}
      }
 
      incr R
      GUIblankRow $Wb $R 1.0
      incr R

      GUILabel $Wb.ltext "Comments" c grid|$R|1|news| 0 0 "" $BFonT

      incr R
      GUIblankRow $Wb $R 1.0
      incr R


      GUIboxText $Wb.text 45 5 grid|$R|1|news| 0 1 "" word

      set R 0
      GUIblankRow $Wc $R 1.0
      incr R

      GUILabel $Wc.mlab "Sub Menus" c grid|$R|1|news||2 15 0 "" $BFonT

      incr R
      GUIblankRow $Wc $R 1.0
      incr R

      GUIblankCol $Wc 0 4.0

      for { set I 0 } { $I < $nB } { incr I } {
         set LaB [lindex $BLab $I]
         set uI [lindex $BFunc $I]
	 set W $Wc.[lindex $BSWin $I]
	 
	 set CoL [expr $I % $BCol + 1]
	 set RoW [expr $I / $BCol + $R]
	 if { $CoL == $BCol } { incr R }

         GUIbuttonPush $W $LaB grid|$RoW|$CoL|ew $uI $MxBLab
      }
   }

   update
   bind .apMENU.im <Return> { .apMENU.sm delete 0 end ; \
                                    .apMENU.sm insert end "$apANS(miFile)"}
}

proc APmenuReflect {  } {
   global apANS env Prefs

   set apANS(miFile) [tk_getOpenFile]
   if [string match #0000FF [.apMENU.sm cget -fg]] {
     .apMENU.sm configure -fg #000000
     set apANS(moFile) $apANS(miFile)
   }
}
