# THIS routine moves a selected label to a new position.  The item must
#    have been selected through a call to APlabelSelect.  The new label
#    position is saved and the new label is output

package provide UDFAnalysis  1.0

proc APlabelMove { W x y } {
   global apANS GphInfo

# MAKE sure that there is an item to move.  Just need a valid slot number

   if [string match NONE $apANS(CurLTag)] { return }

# THIS is the slot number associated with the tag

   set sN [lindex [split $apANS(CurLTag) "_"] 1]

# MAP the new label position to canvas coordinates

   set x [$W canvasx $x]
   set y [$W canvasy $y]

# MAKE correction for the fact that my Y has 0 a bottom of screen and the
#   internal Y is 0 at the top

   set y [expr $GphInfo(yScrL)- $y -1]

# MOVE the label.  This is not really a move but a delete and redraw.  Do
#   this so that the justification of the label is correct at the point
#   selected.

   $W delete $apANS(LAB_,obj)
   
# THINGS we may change and need to reset

   set CSz $GphInfo(tSize)
   set CB  $GphInfo(tBold)

# CHANGE the label position in the menu and set the plot id to _PW_

   set apANS($sN,Lpid) _PW_
   set apANS($sN,Lxoff) $x
   set apANS($sN,Lyoff) $y

# Set the label color and generate the label

   if [info exists GphInfo($apANS($sN,Lcol))] {
      set Color $GphInfo($apANS($sN,Lcol))
   } else { set Color $apANS($sN,Lcol) }

   if [string match X [string index $apANS($sN,Laxis) 0]] {
      set Lab [APgenLab $sN]
   } else { set Lab [APgenLab $sN 1] }

# SET text properties, output label and reset the text properties.  Remember
#   to tag the label!

   TextProp $apANS($sN,Lsize) HOLD $apANS($sN,Lbold)

   set GphInfo(tag) LAB_$sN

   TexT A $x $y 0.0  $apANS($sN,Ljust) $Lab $Color

   TextProp $CSz HOLD $CB

   update
   
# RESET to no tag

   set apANS(CurLTag) NONE

}
