# package provide UDFAnalysis 1.0

# ESTABLISH a grid information array.  There are several types of grids 
#   which can be constructed.  All are based on the input time range. The
#   type of grid to define is specified in gType and the grid information
#   array is returned in gInfo.
#
# gType : SCALARB
#     This is the moments based grid which is used to get the moment data
#     from all four satellites into a common time base.  The number of 
#     cells in the time interval is derived from apANS(CellSz) which is
#     the time in seconds spanned by one cell.  It should be less than the
#     average time it takes to compute a moment.  2 sec should do.  The
#     moments are stored as BAND rather than point
#
# gType : SCALARP 
#     This is identical to MOM but the data is stored as POINT rather than
#     than band.  This is used primarily for orbit data which can then be
#     interpolated to the resolution of the grid rather than remaining 
#     constant over the time resolution its returned - generally 1 minute.
#
# gType : PLOT 
#     This grid is used when building a line plot.  It is identical to
#     SCALAR but the MOM of cells is set to the number of pixels which
#     spans the plot.
  
proc APgridInfo { gType gInfo { pN 0 } { BadL UNSET } { BadU UNSET } } {
   global apANS

   upvar $gInfo gI

   if [string match UNSET $V1] { set V1 $apANS(BaDL) }
   if [string match UNSET $V2] { set V1 $apANS(BaDU) }

# ALL grids are based on the user start and stop times

   set bT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
   set eT [list $apANS(endYr) $apANS(endDy) $apANS(endMs) 0]

# THESE are pretty generic settings and are used in all of the definitions.
#   no need to keep repeating them

   set gI(0) [TUtimeConv $bT $bT 0 apANS(tBase)]
   set gI(1) [TUtimeConv $bT $eT 0 apANS(tBase)]
   set gI(2) -1.0
   set gI(3) 1.0
   set gI(5) 1
   set gI(7) POINT
   set gI(8) COLUMN
   set gI(9) KEEP
   set gI(10) NEW:ADD:END
   set gI(11) $apANS(BaD)
   set gI(12) $apANS(BaD)
   set gI(13) $BadL
   set gI(14) $BadU
   set gI(15) NO
   set gI(16) NO

# THE grid information definitions which depend on the type of grid being
#   extablished

   switch -exact -- $gType {
      SCALARB {
         set dT [expr $gI(1) - $gI(0)]
	 if { [expr fmod($dT, $apANS(CellSz))] != 0.0 } { 
             set gI(4) [expr int(($gI(1) - $gI(0)) / $apANS(CellSz)) + 1]
         } else { set gI(4) [expr int(($gI(1) - $gI(0)) / $apANS(CellSz))] }
         set gI(6) BAND
         set gI(dT) $apANS(CellSz)
      }
      SCALARP {
         set dT [expr $gI(1) - $gI(0)]
	 if { [expr fmod($dT, $apANS(CellSz))] != 0.0 } { 
             set gI(4) [expr int(($gI(1) - $gI(0)) / $apANS(CellSz)) + 1]
         } else { set gI(4) [expr int(($gI(1) - $gI(0)) / $apANS(CellSz))] }
         set gI(6) POINT
         set gI(dT) $apANS(CellSz)
      }
      SCALARNT {
         set gI(0) 0
	 set gI(1) $gI(4)
         set gI(6) POINT
      }
      PLOT {
         set gI(4) $apANS($pN,dX)
         set gI(6) BAND
      }
      PLOTNT {
         set gI(0) 0
	 set gI(1) $gI(4)
         set gI(4) $apANS($pN,dX)
         set gI(6) POINT
      }
   }
}
