package provide UDFAnalysis 1.0

proc APconvMOM { rM rT V1 V2 V3 } {
   global apANS RtoD

   upvar $rM R
   upvar $rT T
   upvar $V1 Vi
   upvar $V2 Vij
   upvar $V3 Vijk

# Put Vi components in correct frame

   TUmatrixMath R * Vi V 3 3 3 1
   set Vi(0) $V(0);  set Vi(1) $V(1);  set Vi(2) $V(2)  

# GET the v(i)v(j) velocities into the right coordinate system.

   set V(0) $Vij(0);  set V(1) $Vij(1);  set V(2) $Vij(2)  
   set V(3) $Vij(1);  set V(4) $Vij(3);  set V(5) $Vij(4)  
   set V(6) $Vij(2);  set V(7) $Vij(4);  set V(8) $Vij(5)  

   TUmatrixMath R * V TmP 3 3 3 3
   TUmatrixMath TmP * T V 3 3 3 3

   set Vij(0) $V(0);  set Vij(1) $V(1);  set Vij(2) $V(2)  
   set Vij(3) $V(4);  set Vij(4) $V(5);  set Vij(5) $V(8)  

# SET the beginning and ending X, Y and Z locations in rotation matrix

   set b(X) 0 ; set e(X) 3
   set b(Y) 3 ; set e(Y) 6
   set b(Z) 6 ; set e(Z) 9

# GET the v(i)v(j)v(k) velocities into the right coordinate system.

   set V(0) $Vijk(0);   set V(1) $Vijk(1);   set V(2) $Vijk(2)  
   set V(3) $Vijk(1);   set V(4) $Vijk(3);   set V(5) $Vijk(4)  
   set V(6) $Vijk(2);   set V(7) $Vijk(4);   set V(8) $Vijk(5)  
   set V(9) $Vijk(1);   set V(10) $Vijk(3);  set V(11) $Vijk(4)  
   set V(12) $Vijk(3);  set V(13) $Vijk(6);  set V(14) $Vijk(7)  
   set V(15) $Vijk(4);  set V(16) $Vijk(7);  set V(17) $Vijk(8)  
   set V(18) $Vijk(2);  set V(19) $Vijk(4);  set V(20) $Vijk(5)  
   set V(21) $Vijk(4);  set V(22) $Vijk(7);  set V(23) $Vijk(8)  
   set V(24) $Vijk(5);  set V(25) $Vijk(8);  set V(26) $Vijk(9)  

   set Vs [ list XXX XXY XXZ XYY XYZ XZZ YYY YYZ YZZ ZZZ]

   for { set I 0 } { $I < 10 } { incr I } {
      set N 0
      set Vijk($I) 0.0
      set cA [string index [lindex $Vs $I] 0]
      set cB [string index [lindex $Vs $I] 1]
      set cC [string index [lindex $Vs $I] 2]
      for { set J $b($cA) } { $J < $e($cA) } { incr J } {
         for { set K $b($cB) } { $K < $e($cB) } { incr K } {
	    set RR [expr $R($J) * $R($K)]
            for { set L $b($cC) } { $L < $e($cC) } { incr L ; incr N } {
               set Vijk($I) [expr $Vijk($I) + $V($N) * $R($L) * $RR]
            }
         }
      }
   }
}
