package provide UFDAnalysis 1.0

proc APfillHoles { nE DaTa Status } {

   upvar $DaTa V
   upvar $Status S

# CHECK to see if we have the Grid Normalization array.  If we do use that and
#   if not then try to recreate it.

   upvar $Norm N
   if ![info exists N ] { 
       set TotGrids [ expr $gI(4) * $gI(5) ]
       for { set I 0 } { $I < $TotGrids } { incr I } {
         if { $G($I) == $gI(11) } {
            set N($I) 0
         } elseif { $G($I) == $gI(12) } {
             set N($I) 2
         } else { set N($I) 1 }
         set FreeN 1
      }
   } else { set FreeN 0 }

# SET up some initial parameters which will make the algorithm independant
#   of whether the grid storage was across rows or up columns
#
# TO be consistant we define Sets as the direction in which fill is not
#   occurring and Vals as the direction it is occurring.

   if { $Dir == "X" } {
      set NumVals $gI(4)
      set NumSets $gI(5)
      if [string match YES $gI(15)] { set Cyclic 1 } else { set Cyclic 0 }
      if [string match ROW $gI(8)] {
         set nS $gI(4)
         set nV 1
      } else {
         set nS 1
         set nV $gI(5)
      }
   } else {
      set NumVals $gI(5)
      set NumSets $gI(4)
      if [string match YES $gI(16)] { set Cyclic 1 } else { set Cyclic 0 }
      if [string match ROW $gI(8)] {
         set nS 1
         set nV $gI(4)
      } else {
         set nS $gI(5)
         set nV 1
      }
   }

   if { $mGap < 0 } { set mGap $NumVals } else { incr mGap 2 }

# SET up some universal variables from how the gaps in the grid are to be
#   filled.

   switch -exact -- $FmT {
      HF {  set P1 { ($LastG % $MoD) * $nV + $BegS }  
            set P2 { ($LastG % $MoD) * $nV + $BegS }  
      }
      HB {  set P1 { ($J % $MoD) * $nV + $BegS }
            set P2 { ($J % $MoD) * $nV + $BegS }  
      }
      LI -
      HM {  set P1 { ($LastG % $MoD) * $nV + $BegS }  
            set P2 { ($J % $MoD) * $nV + $BegS }
      }
   }
   set P3 { ($J % $MoD) * $nV + $BegS }

# BEGIN loop over direction perpendicular to the fill

   set BegS 0
   set Trigger 0
   for { set Sets 0 } { $Sets < $NumSets } { incr Sets ; incr BegS $nS } {

# FIND the first filled element in the grid row or column to be filled

       set J 0
       while { $J < $NumVals } {
          set P [expr $J * $nV + $BegS]
          if { $N($P) == 0.0 } { incr J } else { break }
       }

# IF this row or column has no filled elements then we can't fill it.  Need
#   at least one known value

       if { $J >= $NumVals } { continue }

# SAVE the location of the value first and update pointer to next.

       set pFlg 0
       if { ($J != 0) && $eXtenD } { set eFlg 1 } else { set eFlg 0 }
       set LastG $J
       incr J

# IF this row or column contain cyclic data then we need to provide an effective
#   column or row end which will end up on the first found grid point. 

       if { $Cyclic } { 
          set EffEnD [expr $J + $NumVals ] 
          set MoD $NumVals
       } else { set EffEnD $NumVals ; set MoD 100000000 }

# NOW loop over the remaining points in the row or column finding the next
#   filled location and then interating between them.  
#
# NOTE the cyclic check on J to reset I if necessary

       while { $J < $EffEnD } {
          while { $J < $EffEnD } {
             set P [expr ($J % $MoD) * $nV + $BegS]
             if { $N($P) == 0.0 } { incr J } else { break }
          }
          if { $J >= $EffEnD } { 
             if { $pFlg && $eXtenD } {
                set eFlg 2
                set J $EffEnD
             } else { continue } 
          }

# IF this difference is greater than 1 then there is a gap that needs to be
#  filled.  There are four ways to fill this gap:  we can project the last
#  good value through the gap (HF);  we can project the current value back 
#  through the gap (HB); we can project the last and current values into 
#  the gap to meet at the middle (HM); or we can use a linear interpolation 
#  through the gap using the last and current valid grid values (LI).

          if { $eFlg != 2 } {
             set BeG [expr $LastG + 1]
             set V1 $G([expr $P1])
             set V2 $G([expr $P2])
             set rV [TUfillGap G N $FmT $mGap $BeG $J $MoD $nV $BegS $V1 $V2]
             set Va $V1
             set Vb $G([expr $P3])
             set pFlg 1
          }

          if { $eFlg != 0 } {
             if { $eFlg == 1 } {
                set BeG 0
                set EnD $LastG
                 set A [lindex $rV 0]
                 set B [lindex $rV 1]
                 set V1 [expr $A * ($BeG - 1.0) + $B]
                 set V2 [expr $A * $EnD + $B]
             } else { set BeG [expr $LastG + 1] ; set EnD $J }

             if [string match $FmT LI] { 
                 set A [lindex $rV 0]
                 set B [lindex $rV 1]
                 set V1 [expr $A * ($BeG - 1.0) + $B]
                 set V2 [expr $A * $EnD + $B]
             } else { set V1 $Va ; set V2 $Va }
             TUfillGap G N $FmT $mGap $BeG $EnD $MoD $nV $BegS $V1 $V2
             set eFlg 0
          }

          set Va $Vb
          set LastG $J
          incr J
      }
   }

   if { $FreeN } { unset N }
}
