package provide UDFAnalysis 1.0

proc APallInits { Type { sN 0 } } {
   global apANS GphInfo

# SECOND switch does the initialization

   switch -exact -- $Type {
      EARLY {
         set apANS(BaD)   -1.0e51
         set apANS(BaDU)   1.0e50
         set apANS(BaDL)  -1.0e50
      }
      PREMENU {
         set apANS(FuncTf)   "%1s %-15s %-30s" 
         set apANS(gObjTf)   "%1s %-15s %-30s" 
         set apANS(VarTf)    " %-34s %-5s  %-4s" 

         set apANS(tBase)   1
         set apANS(miFile)  ""
         set apANS(moFile)  ""
         set apANS(NumCom)  0

	 set apANS(EmptyVar) ---

	 set GphInfo(3Dz) UP

	 set apANS(sItems) [list FUNCTION GOBJ LABEL PLOT LAYOUT VARIABLE]
	 set apANS(sWin)   [list .apFUNC.body.list .apGOBJ.body.list \
	                         .apLABEL.body.list .apPLOT.body.list \
				 .apLAYOUT.body.list .apVAR.body.list]
	 set apANS(sId)    [list Func gObj Laxis pType Col Src]

	 set apANS(VARIABLE,sNe) -1
	 set apANS(FUNCTION,sNe) -1
	 set apANS(LAYOUT,sNe) -1
	 set apANS(PLOT,sNe) -1
	 set apANS(LABEL,sNe) -1

	 set apANS(CurSrc)   NONE 
	 set apANS(CurFunc)  NONE 
	 set apANS(CurLTag)  NONE

	 set apANS(GotData) NO

	 set apANS(numGI) 19
      }

      PSET -
      PSCRIPT -
      TIME {
         set nV [APvarList $Type vL $sN]
         for { set I 0 } { $I < $nV } { incr I } {
	    set vI [lindex $vL $I]
	    set vN [lindex $vI 0]
	    set vS [lindex $vI 1]
            if ![info exists apANS($vN)] { set apANS($vN) $vS }
         }
      }
      PREFS {
         set nV [APvarList $Type vL $sN]
         for { set I 0 } { $I < $nV } { incr I } {
	    set vI [lindex $vL $I]
	    set vN [lindex $vI 0]
	    set vS [lindex $vI 1]
            if ![info exists apANS(P,$vN)] { set apANS(P,$vN) $vS }
         }
      }

      default {
         set nV [APvarList $Type vL $sN]

# FIRST see how many variables we are expecting in each definition. Might
#   be more than one if we have read in a predefined menu

         if ![string match $Type VARIABLE] {
            set nD 1
            for { set J 0 } { $J < $nV } { incr J } {
	       set vI [lindex $vL $J]
	       set vN $sN,[lindex $vI 0]
               if [info exists apANS($vN)] {
	          set nD [llength $apANS($vN)]
	          break
               }
            }
         } else { set nD 1 }

         for { set J 0 } { $J < $nV } { incr J } {
	    set vI [lindex $vL $J]
	    set vN $sN,[lindex $vI 0]
	    set vS [lindex $vI 1]
            if ![info exists apANS($vN)] { 
	       set apANS($vN) $vS
               for { set K 1 } { $K < $nD } { incr K } {
	          lappend apANS($vN) $vS
               }
            }
         }
      }
   }
}
