package provide TDShock 1.0

proc NonLinFit { Xn Yn vX vY vZ vV PnTs } {

   global GphInfo

   upvar $vX X
   upvar $vY Y
   upvar $vZ Z
   upvar $vV V

# CENTER the grid of record.  Putting its center at 0, 0 means that the 
#   iterated value is just the 0th order coefficient in the 2D LSq

    for { set K 0 } { $K < $PnTs } { incr K } {
      set Xr($K) [expr $X($K) - $Xn]
      set Yr($K) [expr $Y($K) - $Yn]
    }

# DO the least squares fit to get the intensity in the grid.

    if { $PnTs == 3 } {
         TUdataLSq2D Xr Yr V 3 1 -1 cF
    } else { TUdataLSq3D Xr Yr Z V 4 1 -1 cF 0 }

    return $cF(0)
}
