package provide TDShock 1.0

# THIS procedure picks up all of the data needed to compute the 3D images
#   over the requested time period.  The data consists of the satellite
#   positions and the moment(s) being followed

proc GetUDFData { SetUpInfo } {
   global tdsANS ExDa gMOM gPOS \
          C1X C1Y C1Z C1V C2X C2Y C2Z C2V C3X C3Y C3Z C3V C4X C4Y C4Z C4V

   upvar $SetUpInfo sI

   set Ver 0
   set N 0

#  OBTAIN the UDF Position Data as X, Y, Z
#

   set YY(0) 0.0

#  CLUSTER-1

   set nP 0 
   set CmpTm -1
   set eMs [lindex $tdsANS(PeT) 2]
   while { $CmpTm == -1 } {  
      ReadUDF $sI(12) $Ver $N $sI(13) 0 0 0
      set X($nP) [ConvertToUnits $sI(12) $Ver 0 $sI(14) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set Tm($nP) [TUtimeConv $tdsANS(PbT) $cT 0 tdsANS(mBase)]
      ReadUDF $sI(15) $Ver $N $sI(16) 0 0 0
      set Y($nP) [ConvertToUnits $sI(15) $Ver 0 $sI(17) Data]
      ReadUDF $sI(18) $Ver $N $sI(19) 0 1 0
      set Z($nP) [ConvertToUnits $sI(18) $Ver 0 $sI(20) Data]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                              $tdsANS(PendYr) $tdsANS(PendDy) $eMs ]
puts stderr "C-1 $X(0) $Y(0) $Z(0)" 
       incr nP
   } 

   set eMs [lindex $tdsANS(eT) 2]
   set nE 0 
   set CmpTm -1
   while { $CmpTm == -1 } {  
      ReadUDF $sI(0) $Ver $N $sI(1) 0 1 0
      set V($nE) [ConvertToUnits $sI(0) $Ver 0 $sI(2) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set T($nE) [TUtimeConv $tdsANS(bT) $cT 0 tdsANS(mBase)]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                             $tdsANS(endYr) $tdsANS(endDy) $eMs ]

      incr nE
   }

   TUdataGrid $nP 1 Tm Tm $nP YY YY X C1X Norm gPOS
   TUgridFill1D C1X gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Y C1Y Norm gPOS
   TUgridFill1D C1Y gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Z C1Z Norm gPOS
   TUgridFill1D C1Z gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nE 1 T T $nE YY YY V C1V Norm gMOM
   TUgridFill1D C1V gMOM X $tdsANS(mFill) -1 1

#  CLUSTER-2

   set nP 0 
   set CmpTm -1
   set eMs [lindex $tdsANS(PeT) 2]
   while { $CmpTm == -1 } {  
      ReadUDF $sI(21) $Ver $N $sI(22) 0 0 0
      set X($nP) [ConvertToUnits $sI(21) $Ver 0 $sI(23) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set Tm($nP) [TUtimeConv $tdsANS(PbT) $cT 0 tdsANS(mBase)]
      ReadUDF $sI(24) $Ver $N $sI(25) 0 0 0
      set Y($nP) [ConvertToUnits $sI(24) $Ver 0 $sI(26) Data]
      ReadUDF $sI(27) $Ver $N $sI(28) 0 1 0
      set Z($nP) [ConvertToUnits $sI(27) $Ver 0 $sI(29) Data]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                              $tdsANS(PendYr) $tdsANS(PendDy) $eMs ]
puts stderr "C-2 $X(0) $Y(0) $Z(0)" 
       incr nP
   } 

   set eMs [lindex $tdsANS(eT) 2]
   set nE 0 
   set CmpTm -1
   while { $CmpTm == -1 } {  
      ReadUDF $sI(3) $Ver $N $sI(4) 0 1 0
      set V($nE) [ConvertToUnits $sI(3) $Ver 0 $sI(5) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set T($nE) [TUtimeConv $tdsANS(bT) $cT 0 tdsANS(mBase)]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                             $tdsANS(endYr) $tdsANS(endDy) $eMs ]

      incr nE
   }

   TUdataGrid $nP 1 Tm Tm $nP YY YY X C2X Norm gPOS
   TUgridFill1D C2X gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Y C2Y Norm gPOS
   TUgridFill1D C2Y gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Z C2Z Norm gPOS
   TUgridFill1D C2Z gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nE 1 T T $nE YY YY V C2V Norm gMOM
   TUgridFill1D C2V gMOM X $tdsANS(mFill) -1 1

#  CLUSTER-3

   set nP 0 
   set CmpTm -1
   set eMs [lindex $tdsANS(PeT) 2]
   while { $CmpTm == -1 } {  
      ReadUDF $sI(30) $Ver $N $sI(31) 0 0 0
      set X($nP) [ConvertToUnits $sI(30) $Ver 0 $sI(32) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set Tm($nP) [TUtimeConv $tdsANS(PbT) $cT 0 tdsANS(mBase)]
      ReadUDF $sI(33) $Ver $N $sI(34) 0 0 0
      set Y($nP) [ConvertToUnits $sI(33) $Ver 0 $sI(35) Data]
      ReadUDF $sI(36) $Ver $N $sI(37) 0 1 0
      set Z($nP) [ConvertToUnits $sI(36) $Ver 0 $sI(38) Data]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                              $tdsANS(PendYr) $tdsANS(PendDy) $eMs ]
puts stderr "C-3 $X(0) $Y(0) $Z(0)" 
       incr nP
   } 

   set eMs [lindex $tdsANS(eT) 2]
   set nE 0 
   set CmpTm -1
   while { $CmpTm == -1 } {  
      ReadUDF $sI(6) $Ver $N $sI(7) 0 1 0
      set V($nE) [ConvertToUnits $sI(6) $Ver 0 $sI(8) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set T($nE) [TUtimeConv $tdsANS(bT) $cT 0 tdsANS(mBase)]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                             $tdsANS(endYr) $tdsANS(endDy) $eMs ]

      incr nE
   }

   TUdataGrid $nP 1 Tm Tm $nP YY YY X C3X Norm gPOS
   TUgridFill1D C3X gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Y C3Y Norm gPOS
   TUgridFill1D C3Y gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Z C3Z Norm gPOS
   TUgridFill1D C3Z gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nE 1 T T $nE YY YY V C3V Norm gMOM
   TUgridFill1D C3V gMOM X $tdsANS(mFill) -1 1

#  CLUSTER-4

   set nP 0 
   set CmpTm -1
   set eMs [lindex $tdsANS(PeT) 2]
   while { $CmpTm == -1 } {  
      ReadUDF $sI(39) $Ver $N $sI(40) 0 0 0
      set X($nP) [ConvertToUnits $sI(39) $Ver 0 $sI(41) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set Tm($nP) [TUtimeConv $tdsANS(PbT) $cT 0 tdsANS(mBase)]
      ReadUDF $sI(42) $Ver $N $sI(43) 0 0 0
      set Y($nP) [ConvertToUnits $sI(42) $Ver 0 $sI(44) Data]
      ReadUDF $sI(45) $Ver $N $sI(46) 0 1 0
      set Z($nP) [ConvertToUnits $sI(45) $Ver 0 $sI(47) Data]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                              $tdsANS(PendYr) $tdsANS(PendDy) $eMs ]
puts stderr "C-4 $X(0) $Y(0) $Z(0)" 
       incr nP
   } 

   set eMs [lindex $tdsANS(eT) 2]
   set nE 0 
   set CmpTm -1
   while { $CmpTm == -1 } {  
      ReadUDF $sI(9) $Ver $N $sI(10) 0 1 0
      set V($nE) [ConvertToUnits $sI(9) $Ver 0 $sI(11) Data]
      set cT [list $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) $ExDa($N,BNSEC)]
      set T($nE) [TUtimeConv $tdsANS(bT) $cT 0 tdsANS(mBase)]
      set CmpTm [TUtimeCmp 0 $ExDa($N,BYR) $ExDa($N,BDY) $ExDa($N,BMSEC) \
                             $tdsANS(endYr) $tdsANS(endDy) $eMs ]

      incr nE
   }

   TUdataGrid $nP 1 Tm Tm $nP YY YY X C4X Norm gPOS
   TUgridFill1D C4X gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Y C4Y Norm gPOS
   TUgridFill1D C4Y gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nP 1 Tm Tm $nP YY YY Z C4Z Norm gPOS
   TUgridFill1D C4Z gPOS X $tdsANS(mFill) -1 1
   TUdataGrid $nE 1 T T $nE YY YY V C4V Norm gMOM
   TUgridFill1D C4V gMOM X $tdsANS(mFill) -1 1
}
