package provide TDShock 1.0

# THIS procedure interpolates values along a single grid row in the side
#   of the tetrahedron being filled.
#
#  INPUTS:   pW:     the plot window where output is being sent
#            vX:     array of X coordinates of the 4 vertices
#            vY:     array of Y coordinates of the 4 vertices
#            vZ:     array of Z coordinates of the 4 vertices
#            vV:     array of values for the 4 vertices
#            Ops:    processing parameters
#                Ops(0)  -  Beginning grid column in row  
#                Ops(1)  -  Ending grid column in row  
#                Ops(2)  -  Current grid row  
#                Ops(3)  -  Critical column in row  
#                Ops(4)  -  Critical Intensity
#                Ops(5)  -  Grid dX
#                Ops(6)  -  Grid dY
#                Ops(7)  -  Number of points - nominally 3
#            gInfo:  the overlay grid parameters
#            cInfo:  the color conversion parameters
 
proc FillRow { pW vX vY vZ vV Ops gInfo cInfo } {

   global GphInfo

   upvar $cInfo cI
   upvar $gInfo gI
   upvar $vX X
   upvar $vY Y
   upvar $vZ Z
   upvar $vV V
   upvar $Ops oP

# LOOP over the row and do interpolations.

   for { set J $oP(0) } { $J <= $oP(1) } { incr J } {

# GET the center grid X and Y values of the grid being solved

      TUgridInfo 1 gI rV $J $oP(2)
      TUgridInfo 20 gI P $rV(0)

# CHECK to see if this column number matches the critical column number. If
#   it does then this grid point has a known value and there is no iteration
#   needed.  The value is given by V(oP(4)).

      if { $J == $oP(3) } {
         set cF(0) $oP(4)
      } else {

# CENTER the grid of record.  Putting its center at 0, 0 means that the 
#   iterated value is just the 0th order coefficient in the 2D LSq

         for { set K 0 } { $K < $oP(7) } { incr K } {
            set Xr($K) [expr $X($K) - $P(2)]
            set Yr($K) [expr $Y($K) - $P(3)]
         }

# DO the least squares fit to get the intensity in the grid.

         if { $oP(7) == 3 } {
            TUdataLSq2D Xr Yr V $oP(7) 1 -1 cF
         } else { TUdataLSq3D Xr Yr Z V $oP(7) 1 -1 cF 0 }
      }

      if { $cI(4) == 1 } {
         if {$cF(0) > 0.0 } {
            set C [expr int($cI(0) * log10($cF(0)) + $cI(1))]
         } else { set C -1 }
      } else { set C [expr int($cI(0) * $cF(0) + $cI(1))] }
      if { $C > $cI(3) } { set C $cI(3) }
      PlotColor HOLD $C $C
      set xL [expr $P(2) - $oP(5)]  ;  set yL [expr $P(3) - $oP(6)]
      set xU [expr $P(2) + $oP(5)]  ;  set yU [expr $P(3) + $oP(6)]
      Box $pW $xL $yL 0.0 $xU $yU 0.0
    }

# TURN off fill

    PlotColor HOLD HOLD OFF
}
