package provide TDShock 1.0

# THIS procedure puts up the colorbar and annotates it.
#
#  OUTPUT:   cInfo: the color conversion parameters 
 
proc ClocK { wN Year Day Ms } {
   global GphInfo RtoD

   PlotColor HOLD $GphInfo(White) OFF

   Arc $wN 0.0 0.0 0.0 1.0 0.0 360.0 1 0 1.0

   set YrDy [format "%d %03d" $Year $Day]
   set X 0.0
   set Y [expr 1.0 + 1.5 * [GPHtextLen A Y]]
   TexT $wN $X $Y 0.0 center $YrDy $GphInfo(White)

   set Tm [TUtimeFmt 1 $Year $Day $Ms 0 ] 
   set Hr [lindex $Tm 2]  
   if { $Hr > 12.0 } { set C $GphInfo(Purple) } else { set C $GphInfo(White) }
   PlotColor HOLD $C OFF
   set Hr [expr $Hr % 12]
   set Ang [expr ((3 - $Hr) * 30.0) / $RtoD ]
   set X [expr 0.5 * cos($Ang)]
   set Y [expr 0.5 * sin($Ang)]
   Line $wN 0.0 0.0 0.0 $X $Y 0.0
   PlotColor HOLD $GphInfo(White) OFF
   set Mn [lindex $Tm 3]  
   set Ang [expr ((15 - $Mn) * 6.0) / $RtoD ]
   set X [expr 0.9 * cos($Ang)]
   set Y [expr 0.9 * sin($Ang)]
   Line $wN 0.0 0.0 0.0 $X $Y 0.0
   PlotColor HOLD $GphInfo(Cyan) OFF
   set Sc [lindex $Tm 4]  
   set Ang [expr ((15 - $Sc) * 6.0) / $RtoD ]
   set X [expr 0.95 * cos($Ang)]
   set Y [expr 0.95 * sin($Ang)]
   Line $wN 0.0 0.0 0.0 $X $Y 0.0
}
