#include <string.h>
#include <stdlib.h>
#include "gph_str.h"
#include "gph_opind.h"

int main()
{
   struct scr_info gdv;

   FILE  *fd,*fopen();
   ByTe_4  len,j,fo,tmp,cmd,available;
   ByTe_4  drivercnt = 0;
   ByTe_2 off_ons[100];
   ByTe_2 *s1, tot = 0;
   ByTe_1  n[80], d[40];
   ByTe_1  defns[4000];
   ByTe_1  *c1;
   ByTe_1 SysDevPath[80];
   ByTe_1 DevBinPath[80];
   ByTe_1 DevInfoPath[80];
   ByTe_1  *Fs = PathSep;

   sprintf (SysDevPath, "%s%sinclude%ssys_dev.h",
                             getenv("GPH_HOME"), Fs, Fs);

   if ((fd = fopen (SysDevPath,"r")) == 0)
   {
      fprintf (stderr,"\n\n UNABLE TO OPEN sys_dev.h");
      exit(-1);
   }
            
   c1 = defns;
   s1 = off_ons;
   while (fscanf (fd,"%s %s %hd",d,c1,s1) > 0 && tot < 100) {
      ++tot;
      ++s1;
      c1 += 40;
   }

   fclose (fd);

   sprintf (DevInfoPath,"%s%sdatafiles%sdevice.info",
                                 getenv("GPH_HOME"), Fs, Fs);
   fd = fopen (DevInfoPath,"r");
   sprintf (DevBinPath,"%s%sdatafiles%sdevice.bin",
                                 getenv("GPH_HOME"), Fs, Fs);

#if defined _MaCiNtOsH && !defined __MWERKS__
            fo = creat(DevBinPath);
#else
            fo = creat (DevBinPath,0666);
#endif

#ifdef _CyGnUsC
      setmode (fo, O_BINARY);                       /* binary file           */
#endif

   fscanf (fd,"%d",&tmp);
   write (fo, &tmp, sizeof(ByTe_4));

   for (j=0; j<tmp; ++j)
   {
      gdv.num    = -1;
      gdv.opened =  0;

      /*
       * first let's get the device name
       */
      fscanf (fd,"%c",&n[0]);
      len = 0;
      do
      {
           fscanf (fd,"%c",&gdv.name[len++]);
      }
      while (gdv.name[len-1] != '\n');

      gdv.name[len-1] = '\0';

      fscanf (fd,"%s",d);            /* driver handle */

      available = -1;
      for (c1 = defns, s1= off_ons; s1 < off_ons + tot; ++s1, c1 += 40)
      {
          if (strcmp(c1,d) == 0)
          {
             available = *s1;
             break;
          }
      }

      if (available < 0)
      {
         fprintf (stderr,"\nNO DEVICE <%s (%s)> IN sys_dev.h\n",gdv.name,d);
         available = 0;
      }

      fscanf (fd,"%d",&cmd);         /* position of the driver */
      gdv.drv_num = cmd;

      fscanf (fd,"%s",gdv.dev); /* special path name of the device */
      len = strlen(gdv.dev);
      gdv.dev[len] = '\0';
      fscanf (fd,"%d",&cmd);
      gdv.type = cmd;
      fscanf (fd,"%d",&cmd);
      gdv.lock = cmd;
      fscanf (fd,"%d",&gdv.sleep);
      fscanf (fd,"%f %f",&gdv.s_dimen[0],&gdv.s_dimen[1]);
      fscanf (fd,"%f %f",&gdv.p_dimen[0],&gdv.p_dimen[1]);
      fscanf (fd,"%f %f %f %f",&gdv.p_conv[0],&gdv.p_conv[1],&gdv.p_conv[2],&gdv.p_conv[3]);
      fscanf (fd,"%d",&gdv.seg_inc);
      fscanf (fd,"%hd",&gdv.ctl);
      fscanf (fd,"%hd",&gdv.attri);
      if (available)
      {
          ++drivercnt;
          write (fo,&gdv,sizeof(gdv));
      }
   }
   gdv.hf_sz[0] = 0.0;
   gdv.hf_sz[1] = 0.0;
   lseek (fo,0L,0);
   write (fo, &drivercnt, sizeof(ByTe_4));
   fclose (fd);
   close (fo);
   exit (0);
}
