#include "dbf.h"

#define min(a, b)  (a) < (b) ? a : b

/*************************
*
*  Qsort routine from Bentley & McIlroy's 
*  "Engineering a Sort Function". 
*
*************************/

#define swapcode(TYPE, parmi, parmj, n) {               \
        ByTe_4 i = (n) / sizeof (TYPE);                 \
        register TYPE *pi = (TYPE *) (parmi);           \
        register TYPE *pj = (TYPE *) (parmj);           \
        do {                                            \
                register TYPE   t = *pi;                \
                *pi++ = *pj;                            \
                *pj++ = t;                              \
        } while (--i > 0);                              \
}

static void swapfunc( ByTe_1 *a, ByTe_1 *b, int n, int swaptype)
{
   if(swaptype <= 1) 
       swapcode(ByTe_4, a, b, n)
    else
       swapcode(ByTe_1, a, b, n)
}

static ByTe_1 * med3(ByTe_1 *a, ByTe_1 *b, ByTe_1 *c, int (*cmp)())
{
	return cmp((void *)a, (void *)b) < 0 ?
	       (cmp((void *)b, (void *)c) < 0 ? b : 
               (cmp((void *)a, (void *)c) < 0 ? c : a )) :
               (cmp((void *)b, (void *)c) > 0 ? b : 
               (cmp((void *)a, (void *)c) < 0 ? a : c ));
}

#define SWAPINIT(a, es)                                            \
        swaptype = ((ByTe_1 *)a - (ByTe_1 *)0) % sizeof(ByTe_4) || \
	es % sizeof(ByTe_4) ? 2 : es == sizeof(ByTe_4)? 0 : 1;

#define swap(a, b)				\
	if (swaptype == 0) {			\
           ByTe_4 t = *(ByTe_4 *)(a);		\
           *(ByTe_4 *)(a) = *(ByTe_4 *)(b);	\
           *(ByTe_4 *)(b) = t;			\
        }                                       \
        else					\
           swapfunc(a, b, es, swaptype)

#define vecswap(a, b, n) 	if ((n) > 0)  swapfunc(a, b, n, swaptype)

static ByTe_1 rcsid[] = "$Id: qsort.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

void QSORT (void *A, size_t n, size_t es, int (*cmp)(const void *, const void *))
{
       ByTe_1 *pa, *pb, *pc, *pd, *pl, *pm, *pn;
       ByTe_1 *a = (ByTe_1*)A;
       ByTe_1 *T;

       int d, r, swaptype, swap_cnt;

loop:  SWAPINIT(a, es);
       swap_cnt = 0;
       if (n < 7) 
       {
          for (pm = a + es; pm < a + n * es; pm += es)
          {
             T = pm - es;
             for (pl = pm; pl > a && cmp((void *)T, (void *)pl) > 0; pl -= es)
             {
                swap(pl, T);
                T -= es;
             }
          }
          return;
       }
       pm = a + (n / 2) * es;
       if (n > 7) 
       {
          pl = a;
          pn = a + (n - 1) * es;
          if (n > 40) 
          {
             d = (n / 8) * es;
             pl = med3(pl, pl + d, pl + 2 * d, cmp);
             pm = med3(pm - d, pm, pm + d, cmp);
             pn = med3(pn - 2 * d, pn - d, pn, cmp);
          }
	  pm = med3(pl, pm, pn, cmp);
       }
       swap(a, pm);
       pa = pb = a + es;

       pc = pd = a + (n - 1) * es;
       for (;;) 
       {
          while (pb <= pc && (r = cmp((void *)pb, (void *)a)) <= 0) 
          {
             if (r == 0) 
             {
                swap_cnt = 1;
                swap(pa, pb);
                pa += es;
             }
             pb += es;
          }
          while (pb <= pc && (r = cmp((void *)pc, (void *)a)) >= 0) 
          {
             if (r == 0) 
             {
                swap_cnt = 1;
                swap(pc, pd);
                pd -= es;
             }
             pc -= es;
          }
          if (pb > pc)
              break;
          swap(pb, pc);
          swap_cnt = 1;
          pb += es;
          pc -= es;
       }
       if (swap_cnt == 0) 
       {                                      /* Switch to insertion sort */
          for (pm = a + es; pm <  a + n * es; pm += es)
             for (pl = pm; pl > a && cmp(pl - es, pl) > 0; pl -= es)
                 swap(pl, pl - es);
          return;
       }

       pn = a + n * es;
       r = min(pa - a, pb - pa);
       vecswap(a, pb - r, r);
       r = min(pd - pc, pn - pd - es);
       vecswap(pb, pn - r, r);
       if ((r = pb - pa) > es)
           qsort(a, r / es, es, cmp);
       if ((r = pd - pc) > es) 
       {                  /* Iterate rather than recurse to save stack space */
          a = pn - r;
          n = r / es;
          goto loop;
       }
}
