#include "dbf.h"

/********************
 ** >FILE: db_Qsort.c
 ********************/

int len;

/*****************************************************
 ** Function:  static int qcompare(char *s1, char *s2)
 **
 **    char *s1          string to compare
 **    char *s2          string to compare
 **
 ** Description:
 **    String compare on any character
 **
 ** Retrun Values:
 **
 **********************************/

static int qcompare(const void *s1, const void *s2)
{
   int k;
   ByTe_1 *a, *b;

   a = (ByTe_1 *)s1;
   b = (ByTe_1 *)s2;

   for (k = 1; *a == *b; a++, b++, k++)
   {
      if (k >= len)
      {
         return 0;
      }
   }

   return(*a - *b);
}

/*************************************************************************
 ** Function:  void db_Qsort(char *ndx, int NumRecs, int size, int KeyLen)
 **
 **    char *ndx
 **    int NumRecs
 **    int size
 **    int KeyLen
 **
 ** Description:
 **    Preform the sorting on the index array - use the UNIX quick sort.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: db_Qsort.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

void db_Qsort(ByTe_1 *ndx, int NumRecs, int size, int KeyLen)
{

   /* quicker sort !  */

   len = KeyLen;

   QSORT (ndx, NumRecs, size, qcompare);

}
