#include "OpSySInD.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "dbf.h"

/******************
 ** >FILE: dbFind.c
 ******************/

ByTe_1 *c2;
int ans, KEYLEN;

static ByTe_1 rcsid[] = "$Id: dbFind.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

static int intcompare(i, j)
ByTe_1 *i, *j;
{  
   return((ans=memcmp(i, (c2=j), KEYLEN)));
}

/*********************************************************
 ** Function:  int dbFind(int dbf, int ndx, char *arg, int mode)
 **
 **    int ndx      index handle
 **    char *arg    character string to find
 **    int mode     search flag
 **
 ** Description:
 **    This routine finds the closest or exact entry which matches the arg
 ** key for the database associated with the database structure D.  If mode
 ** is set then the return value reflects the status of the find, either
 ** exact, greater or less match.
 **
 ** Return Values:
 **
 **********************************/

int dbFind(int dbf, int ndx, ByTe_1 *arg, int mode)
{
   register ByTe_1  *fnd;
   register int  rec, rec_size;
   dbfRecord_t *D;
   ndxRecord_t *N;


   if ((D = GetOldDbfHandle(dbf)) == NULL) 
      return FAILURE;

   if ((N = GetOldNdxHandle(dbf, ndx)) == NULL)
      return FAILURE;

   KEYLEN = (N->KeyLen >= strlen(arg)) ? strlen(arg) : N->KeyLen;

   if (D->NumRecs == 0)
      return NO_MATCH ;

   rec_size = N->KeyLen + ALIGN(N->KeyLen) + sizeof(int);

   fnd = (ByTe_1 *)bsearch(arg, N->Index, D->NumRecs, rec_size, intcompare);

   if (fnd != NULL)
   {
      rec = ((fnd - N->Index) / rec_size) + 1;

      if (GoTo(dbf, ItoR(N, rec)) != SUCCESS)
      {
         return FIND_ERROR ;
      }
      N->IndexRec = rec;

      return EXACT_MATCH ;
   }

   if (!mode)
		return NO_MATCH;

/*
   rec = ((((int)c2) - ((int) N->Index)) / rec_size) + 1;
*/

   rec = ((c2 - N->Index) / rec_size) + 1;

   if (GoTo(dbf, ItoR(N, rec)) != SUCCESS)
   {
      return FIND_ERROR ;
   }
   N->IndexRec = rec;

   if (ans < 0)
	{
		return MATCH_LESS;
	}

	return MATCH_GREATER;
}
