#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <errno.h>
#include "dbf.h"

/******************************************************
 ** Function:  int PutDbfRecord(int dbf, int RecNum)
 **
 **    int dbf    handle to database structure
 **
 ** Description:
 **    The PutDbfRecord routine writes the current record to the database
 ** file at RecNum.  THe record number is checked for a valid record number,
 ** if the RecNum number is greater than the number of records in the
 ** database, RecNum is changed to be the new last record number.  If however
 ** RecNum is less than 1 then an error is returned.  The record status is
 ** updated and if this is a new record then the header status is changed to
 ** 'Updated' so the header will be updated upon close.
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: PutDbfRecord.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int PutDbfRecord(int dbf, int RecNum)
{ 
   dbfRecord_t *D;
   ByTe_1 new_rec;
   int nbytes;
#ifndef WIN32
   off_t offset;
#else
   long offset;
#endif

   
   if ((D = GetOldDbfHandle(dbf)) == NULL) 
      return FAILURE;

   new_rec = 0;

   /*
    | check the record numbwe for a valid number
    */
   if (RecNum > D->NumRecs)
   {
      RecNum = D->NumRecs+1;
      D->NumRecs = RecNum;
      new_rec = 1;
      D->CurRecord[0][0] = ' ';
   }

   offset = D->HeadLen + (RecNum-1) * D->RecLen;
   if ((nbytes=lseek(D->dFile, offset, SEEK_SET)) < offset)
   {
      sprintf(msg, "'%s'", D->FileName);
      if (nbytes == -1)
         dbf_code = errno;
      else
         dbf_code = LSEEK_ERROR;
      return FAILURE;
   }

   if ((nbytes=write(D->dFile, (ByTe_1 *)D->CurRecord, D->RecLen)) < D->RecLen)
   {
      sprintf(msg, "'%s'", D->FileName);
      if (nbytes == -1)
         dbf_code = errno;
      else
         dbf_code = errno;
      return FAILURE;
   }

   D->rStatus = NotUpdated;

   if (new_rec)
      D->hStatus = Updated;

   D->CurRec = RecNum;

   dbf_msg_clr;
   dbf_code = 0;
   return SUCCESS;
}
