#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <errno.h>

#include "dbf.h"

/*******************
 ** >FILE: OpenDbf.c
 *******************/

/*************************************************************
 ** Function:  int OpenDbf(int *handle, char *file, int flags)
 **
 ** Description:
 **    This subroutine opens a database file and reads all the necessary
 ** parameters that are used to act upon the file.  The database file
 ** incorporates a dBase III look-a-like format with header information
 ** at the beginning of the file describing the format of the fields and
 ** records.  This information is stored into a structure to be passed to
 ** other database facilities.
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: OpenDbf.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int OpenDbf(int *handle, ByTe_1 *file, int flags)
{
   dbfRecord_t *D;
   int rval;
   register ByTe_1 *c1;
   ByTe_1 *Sep = PathSep;

   if ((D = GetNewDbfHandle(handle)) == NULL)
      return FAILURE;

   strcpy(D->FileName, file);

   /*
    | open the file defined as the database file, if there is an error return
    | error number
    */

   if (Sep[0] != '/') {                          /* Non-Unix path separator */
      c1 = D->FileName;                          /* path pointer            */
      while (*c1 != 0) {                         /* loop over path          */
        if (*c1 == '/') { *c1 = Sep[0]; }        /* change dir separator    */
        ++c1;                                    /* advance pointer         */
      }                                          /* END PATH LOOP           */
   }                                             /* END SUBSTITUTION        */

   if ((D->dFile = open(D->FileName, flags)) < 0)
   {
      sprintf(msg, "'%s'", D->FileName);
      dbf_code = OPEN_ERROR;
      return FAILURE;
   }
   lseek (D->dFile, 0L,  SEEK_SET);

#ifdef _CyGnUsC
   setmode (D->dFile, O_BINARY);
#endif
#ifdef WIN32
      _setmode (D->dFile, O_BINARY);
#endif

   /*
    | read and decode all fields in this database, if there is an error close
    | the file and return the errno number
    */
   if (GetHeader(D) != SUCCESS)
   {
      (void)close(D->dFile);

      return FAILURE;
   }

   /*
    | the fields have been defined, now set some of the status variables
    */
   D->rStatus = NotUpdated;
   D->CurRec  = 0;

   /*
    | if there are records in this database file read the first one
    */
   if (D->NumRecs != 0)
   {
      if ((rval = GetDbfRecord(*handle, 1)) != SUCCESS)
      {
         return rval;
      }
   }

   /*
    | everything was OK
    */
   dbf_code = 0;
   dbf_msg_clr;
   return SUCCESS;
}
