#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include "OpSySInD.h"
#include "dbf.h"

/*
 |
 ||
 ||| MakeHeader() - generate necessary header info based on the record info
 ||
 |
 */

#define Lo(a) ((u_ByTe_1)(a % 256))
#define Hi(a) ((u_ByTe_1)(a / 255))

static ByTe_1 rcsid[] = "$Id: MakeHeader.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int MakeHeader(dbfRecord_t *D, FieldRecord_t *Flds)
{
   extern Header_t tHeader;
   int rval;
   struct tm *mytm;
   time_t tloc = 1;
 
   /*
    | initialize the header buffer to hold all the structure info for the
    | database file
    */
   memset(tHeader, 0, sizeof(Header_t));

   /*
    | generate the month, day, and year for the header info
    */
   time(&tloc);
   mytm = localtime(&tloc);

   tHeader[1] = (u_ByTe_1)mytm->tm_year;   /* Year          */
   tHeader[2] = (u_ByTe_1)mytm->tm_mon+1;  /* Month of year */
   tHeader[3] = (u_ByTe_1)mytm->tm_mday;   /* Day of month  */
 
   /*
    | set the memo field, set the header length based upon the 
    | number of fields passed in
    */
   D->WithMemo = FALSE;
   D->HeadLen  = (D->NumFields + 1) * 32;
   tHeader[D->HeadLen] = 0xD;
   D->HeadLen = D->HeadLen + 1;

   tHeader[8] = Lo(D->HeadLen);
   tHeader[9] = Hi(D->HeadLen);

   /*
    | define all the fields
    */
   if ((rval=MakeFieldDescs(D, Flds)) != SUCCESS)
   {
      return rval;
   }

   if (D->WithMemo == TRUE)
   {
      tHeader[0] = DB3WithMemo;
   }
   else     
   {
      tHeader[0] = DB3File;
   }

   /*
    | must break the record length into 2 bytes and store
    */
   tHeader[10] = Lo(D->RecLen);
   tHeader[11] = Hi(D->RecLen);

   return SUCCESS;
}
