#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <errno.h>

#include "dbf.h"

/*****************************************************
 ** Function:  int GetOneFieldDesc(dbfRecord_t *D,
 **                               FieldDesc_t *F,
 **                               FieldRecord_t *Field,
 **                               int *Offset)
 **
 ** Description:
 **    Decode one field from the header
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetOneFldDesc.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int GetOneFieldDesc(dbfRecord_t *D, FieldDesc_t *F, 
                    FieldRecord_t *Field, int *Offset)
{
   int i;

   /*
    | initialize the field's name 
    */
   memset(Field->Name, 0, sizeof(Field->Name));

   /*
    | get the name of the field
    */
   for (i=0; *(*F+i) != 0 && i <= 10; i++)
   {
      Field->Name[i] = *(*F+i);
   }

   /*
    | the type of the field: Characer, Numeric, Date, Memo, or Logical
    */
   Field->Typ = (ByTe_1) *(*F+11);

   /*
    | decode the length of the field in bytes and get the # of decimals for this
    | field
    */
   Field->Len = *(*F+16);
   Field->Dec = *(*F+17);

   /*
    | generate a pointer to the field in the current record
    */
   Field->Parm = (ByTe_1 *)&(D->CurRecord[0][*Offset]);

   /*
    | increment the offset to the next field description
    */
   *Offset += Field->Len;

   /*
    | make sure this field is valid
    */
   if (!(Field->Typ == CHARACTER || Field->Typ == NUMERIC ||
         Field->Typ == MEMO      || Field->Typ == DATE    ||
         Field->Typ == LOGICAL))
   {
      dbf_msg_clr;
      dbf_code = UNKNOWN_FIELD_TYPE;
      return FAILURE;
   }

   return SUCCESS;
}
