#include <string.h>
#include <errno.h>
#include "dbf.h"

/*******************************************************
 ** Function:  dbfRecord_t *GetNewDbfHandle(int *handle)
 **
 ** Description:
 **    return the handle to a new database structure
 **
 ** Return Values:
 **   * -1 - cannot get a new handle, check dbf_code for explination
 **   * Valid handle number (starting at 0)
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetNewDbf.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

dbfRecord_t *GetNewDbfHandle(int *handle)
{
   dbfRecord_t *D;

   if (dbfRecords == NULL)
   {
      /*
       * no database structures initializes as yet
       */
      if ((dbfRecords = (dbfRecord_t *) calloc(1, sizeof(dbfRecord_t))) == NULL)
      {
         dbf_msg_clr;
         dbf_code = errno;
         return NULL;
      }
      D = dbfRecords;
      D->handle = 1;
   }
   else
   {
      /*
       * need a new handle, allocate a new one and append it to the end
       * of the list of current handles
       */
      for (D = dbfRecords; D->next != NULL; D = D->next);  /* last handle */

      if ((D->next = (dbfRecord_t *) calloc(1, sizeof(dbfRecord_t))) == NULL)
      {  
         dbf_code = errno;
         dbf_msg_clr;
         return NULL;
      }  
      D->next->handle = D->handle + 1;
      D = D->next;
   }
  
   InitDbfHandle(D);

  *handle = D->handle;
   return D;
}
