#include <stdio.h>
#include <string.h>
#include "OpSySInD.h"
#include <errno.h>
#include "dbf.h"

/************************
 ** >FILE: GetDbfRecord.c
 ************************/

/******************************************************
 ** Function:  int GetDbfRecord(int dbf, int RecNum)
 **
 **    int dbf    handle to database structure
 **    int RecNum    record number to read
 **
 ** Description:
 **    This routine reads the RecNm record from the database associated with
 ** the database structure D.  THe RecNum is checked for a valid record
 ** number and returns an error if RecNum is not within a valid record number
 ** range.  Before reading the RecNum record, a check is made to make sure
 ** the current reocrd has not been updated, if it has been updated then the
 ** record is written to the file.
 **
 ** Return Values:
 **    * FAILURE - dbf_code set to actual error
 **    * SUCCESS - the routine completed without error
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: GetDbfRecord.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int GetDbfRecord(int dbf, int RecNum)
{
   dbfRecord_t *D;
   int nbytes;
#ifndef WIN32
   off_t offset;
#else
   long offset;
#endif

   if ((D = GetOldDbfHandle(dbf)) == NULL) 
      return FAILURE;

   /*
    | check for a valid record number
    */
   if (RecNum > D->NumRecs)
   {
      sprintf(msg, "'%s'", D->FileName);
      dbf_code = REC_TOO_HIGH;
      return FAILURE;
   }
   else if (RecNum < 1)
   {
      sprintf(msg, "'%s'", D->FileName);
      dbf_code = REC_TOO_LOW;
      return FAILURE;
   }

   /*
    | update the current record if needed
    */
   if (D->rStatus == Updated)
   {
      if (PutDbfRecord (dbf, D->CurRec) != SUCCESS)
      {
         return FAILURE;
      }
   }

   /*
    | position to the record to read
    */
   offset = D->HeadLen + (RecNum-1) * D->RecLen;
   if ((nbytes=lseek(D->dFile, offset, SEEK_SET)) < offset)
   {
      sprintf(msg, "'%s'", D->FileName);
      if (nbytes == -1)
         dbf_code = errno;
      else
         dbf_code = LSEEK_ERROR;
      return FAILURE;
   }

   if ((nbytes=read(D->dFile, (ByTe_1 *)D->CurRecord, D->RecLen)) < D->RecLen)
   {
      sprintf(msg, "'%s'", D->FileName);
      if (nbytes == -1)
         dbf_code = errno;
      else
         dbf_code = READ_ERROR;
      return FAILURE;
   }

   /*
    | update the current record number
    */
   D->CurRec = RecNum;

   dbf_msg_clr;
   dbf_code = 0;
   return SUCCESS;
}
