#include <stdio.h>
#include "dbf.h"

static ByTe_1 rcsid[] = "$Id: DateFormat.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

void DateFormat(ByTe_1 *data, ByTe_1 *date)
{
   int yr, mm, dd, yy;

   sscanf(data, "%4d%2d%2d", &yr, &mm, &dd);

   yy = yr % 100;

   switch (SET.Date)
   {
      case AMERICAN:  /* mm/dd/yy */
         sprintf(date, "%02d/%02d/%02d", mm, dd, yy);
         break;

      case ANSI:     /* yy.mm.dd */
         sprintf(date, "%02d.%02d.%02d", yy, mm, dd);
         break;

      case BRITISH:  /* dd/mm/yy */
         sprintf(date, "%02d/%02d/%02d", dd, mm, yy);
         break;

      case GERMAN:   /* dd.mm.yy */
         sprintf(date, "%02d.%02d.%02d", dd, mm, yy);
         break;

      case ITALIAN:  /* dd-mm-yy */
         sprintf(date, "%02d/%02d/%02d", dd, mm, yy);
         break;

      case JAPAN:    /* yy/mm/dd */
         sprintf(date, "%02d/%02d/%02d", yy, mm, dd);
         break;

      case USA:      /* mm-dd-yy */
         sprintf(date, "%02d-%02d-%02d", mm, dd, yy);
         break;

      case RAW:     /* yyyymmdd - as the raw format */
         sprintf(date, "%s", data);
         break;

      default:      /* mm-dd-yy */
         sprintf(date, "%02d-%02d-%02d", mm, dd, yy);
         break;
   }
}
