#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include "OpSySInD.h"
#include "dbf.h"

/*********************
 ** >FILE: CreateDbf.c
 *********************/

Header_t tHeader;

/*****************************************************************************
 ** Function:  int CreateDbf(int *handle, char *fn, int n, FieldRecord_t *Flds)
 **
 **    int *handle   - database handle
 **    char *fn      - file name for to create for the database
 **    int n         - number of fields in the database
 **    FieldRecord_t *Flds - pointer to the field descriptions
 **
 ** Description:
 **    Call this procedure with the full pathname of the file that you want
 ** to create (fn), the number of fields in a record (n), and a pointer
 ** to an array of FieldRecord_t (Flds).  The procedure will initialize all
 ** the data structures in the dbfRecord (D).
 **
 ** Return Values:
 **
 **********************************/

static ByTe_1 rcsid[] = "$Id: CreateDbf.c,v 1.1 1999/11/13 17:45:28 chris.gurgiolo.b2r Stab chrisg $";

int CreateDbf(int *handle, ByTe_1 *fn, int n, FieldRecord_t *Flds)
{
   int i, offset, rval;
   dbfRecord_t *D;

   memset(tHeader, 0, sizeof(Header_t));

   if ((D = GetNewDbfHandle(handle)) == NULL)
      return FAILURE;

   /*
    | set the number of fields passed in then put them into the database
    | structure
    */
   D->NumFields = n;

   /*
    | fill the header with the field info
    */
   if ((rval=MakeHeader(D, Flds)) != SUCCESS)
   {
      return rval;
   }

   /*
    | store away the database file name and open the file
    */
   (void)strcpy(D->FileName, fn);
   if ((D->dFile = open(D->FileName, O_WRONLY)) < 0)
   {

#if defined _MaCiNtOsH && !defined __MWERKS__
      if ((D->dFile = creat(D->FileName)) < 0)
#else 
      if ((D->dFile = creat(D->FileName, 0666)) < 0)
#endif
      {
         dbf_code = errno;
         sprintf(msg, "'%s'", D->FileName);
         return FAILURE;
      }
   }

   lseek (D->dFile, 0L, SEEK_SET);

#ifdef _CyGnUsC
   setmode (D->dFile, O_BINARY);
#endif
#ifdef WIN32
      _setmode (D->dFile, O_BINARY);
#endif

   /*
    | set the number of record in the database to zero
    */
   tHeader[4] = 0;
   tHeader[5] = 0;
   tHeader[6] = 0;
   tHeader[7] = 0;

   /*
    | write out the header info
    */
   if (write(D->dFile, tHeader, D->HeadLen) < 0)
   {
      dbf_code = errno;
      sprintf(msg, "'%s'", D->FileName);
      return FAILURE;
   }

   /*
    | initialize the header status, the number of records currently in the
    | database and the date of the last update
    */
   D->hStatus = NotUpdated;
   D->NumRecs = 0;
   memcpy(D->HeadProlog, tHeader, sizeof(D->HeadProlog));
   (void)strcpy(D->DateOfUpdate, "  /  /  ");
   (void)sprintf(D->DateOfUpdate, "%02d/%02d/%02d", tHeader[2], tHeader[3],
                                                                    tHeader[1]);

   /*
    | allocate the memory for the current database record (only one)
    */
   if ((D->CurRecord = (DataRecord_t *)calloc(1, D->RecLen)) == NULL)
   {
      dbf_msg_clr;
      dbf_code = errno;
      return FAILURE;
   }

   /*
    | allocate the memory for the field definitions in the database structure
    */
   if ((D->Fields = (FieldRecord_t *)calloc(D->NumFields, sizeof(FieldRecord_t))) == NULL)
   {
      dbf_code = errno;
      dbf_msg_clr;
      return FAILURE;
   }

   /*
    | store the field definitions in the database structure
    */
   offset = 1;
   for (i=0; i<D->NumFields; i++)
   {
      D->Fields[i] = Flds[i];
      D->Fields[i].Parm = (ByTe_1 *)&(D->CurRecord[0][offset]);
      offset += D->Fields[i].Len;
   }
     
   /*
    | this database has just been created, there are no records in it .. yet
    */
   D->CurRec = 0;

   dbf_code = 0;
   dbf_msg_clr;
   return SUCCESS;
} 
