#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "OpSySInD.h"
#include "libCfg.h"
#include "Pconfig.h"

static ByTe_1 rcsid[] = "$Id: pc_get_line.c,v 1.1 1999/11/12 19:57:31 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 *pc_get_line(FILE *fp, ByTe_1 **buffer, int *bufsize)
{
   ByTe_1 *bp, *end;
   ByTe_1 line[256];
   int  buflen, eof, esc, line_len;

/*
   Initialize buflen and eof to zero.
*/
   buflen = eof = 0;

/*
   Get a line from the input stream and append it to the contents
   of buffer.  If the line ends with an escaped newline or no newline,
   get another line and append it to buffer.  Continue until an unescaped
   newline is read or the input stream terminates.  If the input terminates,
   set Eof to indicate the termination.
*/
   do
   {
      if (fgets(line, 256, fp) == NULL)
      {
         eof = 1;
         break;
      }

/*
   Get the length of the line.
*/
      line_len = strlen(line);

/*
   If the length of the line plus the current contents of the buffer
   is greater than the length of the buffer, grow the buffer.  If there
   is an error, report it and return NULL.
*/
      if (line_len + buflen > *bufsize) {
         *bufsize = buflen + line_len + 1024;
         if (*buffer == NULL)
            *buffer = (ByTe_1 *)malloc(*bufsize);
         else
            *buffer =  (ByTe_1 *)realloc((ByTe_1 *)*buffer, *bufsize);
         if (*buffer == NULL) {
            perror("open_config.pc_get.line");
            return NULL;
         }
      }
      
/*
  Copy the line into buffer.  While copying, scan the line to get the
  context of any ending newline.  Anytime a backslash occurs, consider
  the next character to be escaped.  When a newline is reached, end the
  search.  The status of the newline will be shown in esc.  If the line
  did not end on a newline, set esc as well, since it will indicate
  a need to read more input.  Terminate the copy into buffer with a '\0'.
  Note that the newlines are not copied into buffer, and that the back-
  slash escaping a final newline is not kept either.
*/
      bp = *buffer + buflen;

      for (end = line, esc = 0; *end != '\0' ; buflen++)
      {
         if (esc) {
            if ((*end == '\n') || (*end == '\r')) {
               buflen--;
               bp--;
               break;
            } else { esc = 0; }
         }
         else if (*end == '\\')
         {
            esc = 1;
         }
         else if ((*end == '\n') || (*end == '\r'))
         {
            break;
         }

         *bp++ = *end++;
      }

      esc = (*end == '\0') ? 1 : esc;

      *bp = '\0';

/*
   As long as esc is set, indicating that more input needs to read,
   continue.
*/
   }
   while (esc);

/*
   If buflen is zero and eof is set when we are finished then no
   input was read and the input stream has terminated.  In that case
   return a NULL, otherwise return a pointer to buffer.
*/
   return ((!buflen && eof) ? NULL : *buffer);
}
