#ifndef _libCfg_h
#define _libCfg_h

#include "ByteDefs.h"
#include "LinkList.h"
#include "StrHier.h"
#include "ItemValue.h"
#include "Pconfig.h"
#include "ant.h"


#define PROJECTScfg "PROJECTS.cfg"
#define ITEMcfg "DB.cfg"

#ifndef SUCCESS
#define SUCCESS 1
#endif
#ifndef FAILURE
#define FAILURE 0
#endif

void        CfgInit();
ByTe_1      *CfgPath(StrHier, ByTe_1 *, int);
ItemValue_t *CreateItemValue(int);
int         DB_Config(ByTe_1 *, LinkList);
ByTe_1      *DbfFile(StrHier);
void        DestroyItemValue(void  *V);
ByTe_1      *DupStr (ByTe_1 *);
ByTe_1      *FindItemValue(ItemValue_t *, ByTe_1 *, int);
LinkList    IdfsNextItems_sublist( StrHier );
LinkList    P_Config(ByTe_1 *);
LinkList    ScfNextItems( StrHier );
StrHier     SourceByNum(LinkList list, ...);
StrHier     SourceByStr(LinkList, ...);
LinkList    VidfNextItems (StrHier );

LinkList    aConfig(config_t *, ByTe_1 *, StrHier);
void        aP_Free(LinkList P);
ByTe_1      *get_symbol(config_t *, ByTe_1 *);
config_t    *open_config(ByTe_1 *);
int         parse_config(config_t *, ByTe_1 *, def_t *);
int         pc_add_symbol(config_t *, ByTe_1 *, ByTe_1 *);
config_t    *pc_destroy_config(config_t *);
ByTe_1      *pc_get_line(FILE *, ByTe_1 **, int *);
int         pc_get_tokens(FILE *, ByTe_1 **, ByTe_1 **, ByTe_1 **, int *);
void        process_symbol(def_t *, ByTe_1 *);


#ifdef _CfgInit_
LinkList Projects = 0x0;
int silent = 1, NCP = 1;
#else
extern LinkList Projects;
extern int silent, NCP;
#endif

#endif

