#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                           KEY_TO_FIELDS SUBROUTINE                          *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine returns the project, mission, experiment, instrument and    *
 *  virtual instrument numbers associated with the specified data key.         *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    unsigned long data_key       key which uniquely identifies the data set  *
 *                                 being processed                             *
 *    short *params                pointer to the area in which the numbers    *
 *                                 are returned                                *
 *                                                                             *
 *  USAGE                                                                      *
 *    key_to_fields (new_key, &params)                                         *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    None                                                                     *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    short project                the project value                           *
 *    short mission                the mission value                           *
 *    short exper                  the experiment value                        *
 *    short inst                   the instrument value                        *
 *    short vinst                  the virtual instrument value                *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void key_to_fields (u_ByTe_4 new_key, ByTe_2 *params)
{
    ByTe_2 project, mission, exper, inst, vinst;

    /***********************************************************************/
    /*  The values used in the equations are explained as follows:         */
    /*     127 used as mask to retrieve 7 bits set for VIRTUAL INST.       */
    /*     8064 used as mask to retrieve 6 bits set for INSTRUMENT         */
    /*     516096 used as mask to retrieve 6 bits set for EXPERIMENT       */
    /*     7864320 used as mask to retrieve 4 bits set for MISSION         */
    /*     4286578688 for PROJECT sets top 9 bits of the 32 bit uns long.  */
    /***********************************************************************/

    project = (new_key & 4286578688) >> 23;
    mission = (new_key & 7864320) >> 19;
    exper = (new_key & 516096) >> 13;
    inst = (new_key & 8064) >> 7;
    vinst = (new_key & 127);

    *(params) = project;
    *(params + 1) = mission;
    *(params + 2) = exper;
    *(params + 3) = inst;
    *(params + 4) = vinst;
}
