#include <stdlib.h>
#include "gen_defs.h"
#include "VidfDefs.h"
#include "libbase_udf.h"
#include "libCfg.h"

#define FILL_SZ 8192
struct general_info ginfo;
struct def_oper IDF_OPER[13];
void   *Tmp_Space;
ByTe_1 plot_package, ReSetSen, block_adv, inside_reset_exp;
ReaL_4 conv_fill[FILL_SZ];
size_t Tmp_Bytes;
ByTe_4 InitIdfsEntry;
ByTe_1 BswaP;

/******************************************************************************
 *                                                                            *
 *                           INIT_UDF  SUBROUTINE                             *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine is called once at the beginning of a program in order to   *
 *  initialize some of the information that is pertinent to the processing of *
 *  IDFS information.  The operations enabled for tables defined in the VIDF  *
 *  document must be initialized and the number of open file descriptors is   *
 *  set to the maximum allowed for a single process.                          *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    None                                                                    *
 *                                                                            *
 *  USAGE                                                                     *
 *    init_udf ()                                                             *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    ir_init_struct ()            initializes elements in the global data    *
 *                                 structure used by the generic routines     *
 *    ir_oper_asgn ()              sets up the array of pointers to the       *
 *                                 routines that perform the arithmetic       *
 *                                 operations defined for the VIDF tables     *
 *    ir_set_fd_limit ()           sets the limit on the number of open file  *
 *                                 descriptors per processes to the maximum   *
 *    CfgInit()                    initializes playback communications        *
 *    malloc()                     allocates memory                           *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    unsigned int Tmp_Bytes       number bytes allocated for scratch space   *
 *    long InitIdfsEntry           variable safeguarding against multiple     *
 *                                 entries for this routine                   *
 *    void *Tmp_Space              scratch space for various uses             *
 *    char block_adv               flag indicating if time advancement should *
 *                                 be blocked                                 *
 *    char plot_package            flag indicating if the plotting or menu    *
 *                                 program made the call (will not be changed *
 *                                 from the default of plotting for the       *
 *                                 generic user)                              *
 *    char inside_reset_exp        flag set if in the RESET_EXPERIMENT_INFO   *
 *                                 module (needed for FILE_OPEN logic)        *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    NONE                                                                    *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

void init_udf (void)
{

   /*************************************************************************/
   /*  Try to safeguard against this routine being called more than once.   */
   /*************************************************************************/

   if (InitIdfsEntry == 1234567890)
     return;

   /*************************************************************************/
   /*  Initialize elements.                                                 */
   /*************************************************************************/

   ir_init_struct ();
   ir_oper_asgn ();
   Tmp_Space = NO_MEMORY;
   Tmp_Bytes = 1024;
   block_adv = 0;
   plot_package = 1;
   inside_reset_exp = 0;
   CfgInit();

/* ........................ */
/*   ir_set_fd_limit ();    */
/* ........................ */

   /***********************************************************************/
   /*  Allocate temporary scratch space to be used.  If the malloc fails, */
   /*  simply set number of bytes so other modules will allocate.  This   */
   /*  was done so that the calling sequence would not have to change.    */
   /***********************************************************************/

   if ((Tmp_Space = malloc (Tmp_Bytes)) == NO_MEMORY)
    {
      Tmp_Space = NO_MEMORY;
      Tmp_Bytes = 0;
    }

   InitIdfsEntry = 1234567890;
}
