#include <stdlib.h>
#include <stdio.h>
#include "util_str.h"
#include "ret_codes.h"
#include "OpSySInD.h"
#include "libbase_udf.h"
#include "gen_defs.h"
#include "user_defs.h"
#include "PidfAnsi.h"
#include "Server.h"

/******************************************************************************
 *                                                                            *
 *                         IR_FILE_SETUP SUBROUTINE                           *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine retrieves and opens the necessary header, data, and VIDF   *
 *  files for the time period and data set requested.  Space is allocated for *
 *  the flags that indicate which of the sensors for each data set are going  *
 *  to be processed.  The flags are set to indicate that all sensors will be  *
 *  processed (default scenario).  It was decided to turn on ALL sensor flags *
 *  so that the generic user would get some data, even though by doing so, it *
 *  is possible to end up allocating space for unneeeded sensor information.  *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    unsigned long Key            key which uniquely identifies the data set *
 *                                 being processed                            *
 *    char *exten                  filename extension for the data to be used *
 *    unsigned short vN            version number to be associated with this  *
 *                                 combination (allows for multiple opens)    *
 *    short bY                     start time requested (year component)      *
 *    short bD                     start time requested (day component)       *
 *    long bS                      start time requested (seconds component)   *
 *    long bNs                     start time requested (nanoseconds)         *
 *    short eY                     stop time requested (year component)       *
 *    short eD                     stop time requested (day component)        *
 *    long eS                      stop time requested (seconds component)    *
 *    long eNs                     stop time requested (nanoseconds)          *
 *                                                                            *
 *  USAGE                                                                     *
 *    rV = ir_file_setup (Key, exten, vN, bY, bD, bS, bNs, eY, eD, eS, eNs)   *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    sizeof ()                    the size of the specified object in bytes  *
 *    ir_playback_data_files()     opens the header, data, and idf files for  *
 *                                 the time period and data set specified     *
 *                                 (playback mode only)                       *
 *    ir_realtime_data_files()     opens the header, data, and idf files for  *
 *                                 the data set specified (real-time          *
 *                                 acquisition only)                          *
 *    ir_locate_ex()               determines if requested combination has    *
 *                                 already been processed and points to the   *
 *                                 correct structure allocated for the combo  *
 *    ir_read_idf_once()           retrieves some of the pertinent info. from *
 *                                 the IDF file (value needs to be read once  *
 *                                 and is stored away for future use)         *
 *    ir_free_vidf_structure ()    frees memory allocated for VIDF processing *
 *    init_vidf ()                 sets up information so that the VIDF data  *
 *                                 is accessed correctly                      *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    struct general_info          structure holding information concerning   *
 *         ginfo                   the experiment that is being processed     *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    reg struct experiment_info   a pointer to the structure that holds      *
 *            *ex                  specific experiment information            *
 *    long rval                    the value returned by the called routine   *
 *    short rV                     the value returned by the called routine   *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *  Update: Dec 14, 1996 - added auto_swap feature - chris.gurgiolo.b2r       *
 *  Update: Sept 11, 1999 - removed auto_swap feature - chris.gurgiolo.b2r    *
 *                                                                            *
 *****************************************************************************/

ByTe_2 ir_file_setup (u_ByTe_4 Key, ByTe_1 *exten, u_ByTe_2 vN, 
                      ByTe_2 bY, ByTe_2 bD, ByTe_4 bS, ByTe_4 bNs, 
		      ByTe_2 eY, ByTe_2 eD, ByTe_4 eS, ByTe_4 eNs)
{
   extern struct general_info ginfo;
   extern ByTe_1 BswaP;
   register struct experiment_info *ex;
   ByTe_4 rval;
   ByTe_2 rV, Pstat = 0;
   ByTe_1 pFlg;

  /********************************************************************/
  /*  Determine if this UDF definition has been processed before or   */
  /*  if this is a new definition which needs to be initialized.      */
  /*  Since ir_locate_ex() is called by many routines return an error */
  /*  error that indicates the calling routine generating the error.  */
  /*  There are 3 possible errors since last parameter is set to 1.   */
  /********************************************************************/

   rV = ir_locate_ex (Key, exten, vN, 1);
   if (rV != ALL_OKAY) {
      switch (rV) {
          case LOCATE_EX_MALLOC:  return (OPEN_EX_MALLOC);
          case LOCATE_PTR_MALLOC: return (OPEN_PTR_MALLOC);
          case LOCATE_EX_REALLOC: return (OPEN_EX_REALLOC);
       }
    }

  /********************************************************************/
  /*  Save the requested start time.                                  */
  /********************************************************************/

   ex = ginfo.expt;
   ex->btime_year = bY;
   ex->btime_day = bD;
   ex->btime_sec = bS;
   ex->btime_nsec = bNs;
   ex->BswaP = 0;
   ex->DswaP = 1;

#ifdef _ReaLTimE_

  /********************************************************************/
  /*  Check the realtime data area for the data selected. If the file */
  /*  descriptor is already set there is no need to reopen the files. */
  /********************************************************************/

   if ((bS < 0) && (ex->fdh == -1)) {
      rV = ir_realtime_data_files (bY, bD, bS,
                                   bNs, eY, eD, eS,
                                   eNs, Key, exten);

      if (rV != ALL_OKAY) { return (rV); }
   } else {

#endif

      rV = ir_playback_data_files (Key, bY, bD, bS, bNs, eY, 
                                                   eD, eS, eNs, exten);

      pFlg = ((rV == NO_V) || (rV == NO_HD) ||(rV == NO_HDV)) ? 1 : 0;

      if ((ex->fdd == -1) || (ex->fdh == -1) || (ex->fdi == -1) || pFlg)  {
         if (getenv("UDFPROMOTE") != NULL) {
            sscanf (getenv("UDFPROMOTE"), "%hd", &Pstat);
            if (Pstat < 0 ) { Pstat = -Pstat; }

            if ((rV == NO_V) || (rV == NO_HDV) || (ex->fdi == -1)) {
	        if (ex->fdi >= 0) { close(ex->fdi); }
                rV = PromoteFile ("SEARCHV", Key, bY, bD, bS * 1000, 
                          eY, eD, eS * 1000, Pstat ); 
            }
            if ( (ex->fdd == -1) || (ex->fdh == -1) || (rV == NO_HD) || 
	        (rV == NO_HDV) ) {
                rV = PromoteFile ("SEARCH", Key, bY, bD, bS * 1000, 
                          eY, eD, eS * 1000, Pstat ); 
            }

            rV = ir_playback_data_files (Key, bY, bD, bS, bNs, eY, 
                                eD, eS, eNs, exten);
         }
         if ((ex->fdd == -1) || (ex->fdh == -1) || (ex->fdi == -1))  {
            rV = 1200; 
	 } else { rV = ALL_OKAY; }
      }

      if (rV != ALL_OKAY) { return(rV); }

#ifdef _ReaLTimE_
   }
#endif

  /*********************************************************************/
  /* Check to see if we are on a big endian system and got a file that */
  /* that is formatted little endian or vice versa.  In these cases we */
  /* need to swap byte order after reading the data.                   */
  /*********************************************************************/

   GetOrdering (Key); 
   BswaP = ex->BswaP;

  /*********************************************************************/
  /*  The data word length is initialized to -1.  It gets set after    */
  /*  the VIDF file is read.  If its still -1 then we need to read     */
  /*  the VIDF file and initial some of the elements in the experiment */
  /*  information file.                                                */
  /*********************************************************************/

   if (ex->tdw_len == -1) {
      rval = init_vidf (Key, exten, vN, VIDF_FROM_MEMORY);
      if (rval < 0) {
         ir_free_vidf_structure (ex);
         return ((ByTe_2)rval);
      }

      rV = ir_read_idf_once ();
      if (rV != ALL_OKAY) {
         ir_free_vidf_structure (ex);
         return (rV);
      }
   }

   ex->first_open = 0;

   return (ALL_OKAY);
}
