#include <math.h>
#include "util_str.h"
#include "user_defs.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                        IR_COMPUTE_PITCH_ANGLE SUBROUTINE                    *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine computes the pitch angle for each time period associated    *
 *  with each element of the sweep.  The dot product of the unit normal to the *
 *  detector aperture with the local magnetic field is computed.  The value    *
 *  computed is in terms of radians, so the value is converted to degrees      *
 *  before it is returned.                                                     *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    struct pitch_info *pa_ptr   a pointer to the structure that holds pitch  *
 *                                angle information                            *
 *    void *UDF                   pointer to data structure                    *
 *    short sensor                the sensor for which data is requested       *
 *    unsigned short max_ele      the number of elements in the sweep          *
 *                                                                             *
 *  USAGE                                                                      *
 *    ir_compute_pitch_angle (pa_ptr, &pitch_data, sensor, max_ele)            *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    sqrt ()                     returns the square root of the argument      *
 *    acos ()                     returns arc cosine of input                  *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    reg unsigned short swp_step the sweep step being processed               *
 *    register double *unit_vec   ptr to the unit normal vector                *
 *    register double *mag_vec    ptr to the magnetic field vector             *
 *    register double *vec_end    loop termination variable                    *
 *    double top_val              the result of calculation for the numerator  *
 *    double mag_sum              the summation of the magnetic field elements *
 *    double bot_val              the result of the calculation for denominator*
 *    double dot_data             the computed dot product value               *
 *    double ret_data             the computed pitch angle value               *
 *    int offset                  offset into allocated memory                 *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void ir_compute_pitch_angle (struct pitch_info *pA, void *UDF, 
                             ByTe_2 sensor, u_ByTe_2 max_ele)
{

   /*********************************************************************/
   /* process ptich angles according to the format found in the VIDF    */
   /*********************************************************************/

   switch (pA->pa_format)
   {
      case 0:
        PaFormat0 (pA, UDF, sensor, max_ele);
      break;
      case 1:
        PaFormat1 (pA, UDF, sensor, max_ele);
      break;
   }
}
