#include <stdlib.h>
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/******************************************************************************
 *                                                                            *
 *                          IR_ALLOC_SWP_DATA SUBROUTINE                      *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine is called to allocate the array that holds the sample      *
 *  sequence values that are returned in the generic idf_data data structure. *
 *  The array will end up being maxed out by the virtual instrument returning *
 *  the most samples or may be maxed out by the instrument using the most     *
 *  center bin values.                                                        *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    unsigned short num_ele     number of sample sequence values             *
 *    void *idf_data_ptr         ptr to the memory location for the structure *
 *                               that holds returned data values (read_drec)  *
 *                                                                            *
 *  USAGE                                                                     *
 *    x = ir_alloc_swp_data (num_ele, idf_data_ptr)                           *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *    malloc()                   allocates memory                             *
 *    sizeof ()                  the size of the specified object in bytes    *
 *                                                                            *
 *  EXTERNAL VARIABLES                                                        *
 *    None                                                                    *
 *                                                                            *
 *  INTERNAL VARIABLES                                                        *
 *    struct idf_data *EXP_DATA  structure that holds all of the currently    *
 *                               returned data values to be processed         *
 *    size_t B                   the number of bytes to allocate              *
 *                                                                            *
 *  SUBSYSTEM                                                                 *
 *    Display Level                                                           *
 *                                                                            *
 *****************************************************************************/

ByTe_2 ir_alloc_swp_data (u_ByTe_2 num_ele, void *idf_data_ptr)
{
   struct idf_data *EXP_DATA;
   size_t B;

  /*************************************************************************/
  /*  Allocate space to hold the sample sequence values that are to be     */
  /*  returned to the user if no memory has been allocated yet.            */
  /*  CAG 12/16/08 - removed a realloc in favor of a free/malloc           */
  /*************************************************************************/

   EXP_DATA = (struct idf_data *) idf_data_ptr;
   B = num_ele * sizeof (ByTe_4);

   if (B > EXP_DATA->swp_size) {
      if (EXP_DATA->base_swp != NO_MEMORY) {
         free(EXP_DATA->base_swp);
         EXP_DATA->base_swp = NO_MEMORY;
         EXP_DATA->swp_size = 0;
      }

      if ((EXP_DATA->base_swp = malloc(B)) == NO_MEMORY)
         return (ALLOC_EV_MALLOC);
      EXP_DATA->swp_data = (ByTe_4 *) EXP_DATA->base_swp;
      EXP_DATA->swp_size = B;
   }

  return (ALL_OKAY);
}
