#include "OpSySInD.h"
#include <stdio.h>
#include "util_str.h"
#include "ret_codes.h"
#include "gen_defs.h"
#include "libbase_udf.h"

ByTe_2 ToThisTime (u_ByTe_4 KeY, ByTe_1 *EX, u_ByTe_2 VeR, void *UDF,
                   ByTe_2 bY, ByTe_2 bD, ByTe_4 bS, ByTe_4 bN,
                   ByTe_2 eY, ByTe_2 eD, ByTe_4 eS, ByTe_4 eN)
{
   extern struct general_info ginfo;

   struct experiment_info *eX;
   struct ptr_rec *pTr;

   ByTe_4 NBytes, Low, Hi, Mid;
   ByTe_4 rS, rNs;
   ByTe_4 dY, dD, dS, dT;

   ByTe_4 NRecords, RBeg, bM,  rV, *Hdr;
   ByTe_4 Rsz;
   ByTe_2 Rv; 
   ByTe_1 ResetCalled, DonE;

   /************************************************************************/
   /*  Check to see if the virtual being processed is recognized as having */
   /*  been initilized. If not post an error condition - probably no call  */
   /*  to file_open has been made.                                         */
   /************************************************************************/
  
   if (!ginfo.called_locate) {
      if ((Rv = ir_locate_ex (KeY, EX, VeR, 0)) != ALL_OKAY)
        return (Rv);
 
      ginfo.called_locate = 1;
      ResetCalled = 1;
   } else { ResetCalled = 0; }

   eX  = ginfo.expt;                             /* experiment info struct */
   pTr = eX->info_ptr;                           /* header info here       */
   eX->fnext = 0;                                /* start time not found   */ 
   eX->hrec_eof = 0;                             /* header file not eof    */
   eX->drec_eof = 0;                             /* data file not eof      */

   /************************************************************************/
   /*  Get some initial file information and get ready for a binary search */
   /************************************************************************/

   bM = bS * 1000 + bN / 1000000;                /* user time in msec      */

   if ((rV = FileLength (eX->data_name, &NBytes)) < 0) {
      if (ResetCalled)
         ginfo.called_locate = 0;
      return (rV - 330);
   }

   NRecords = NBytes / pTr->d_size;              /* Data recs in file      */
   Low = 0;                                      /* Init binary search Low */
   Hi = NRecords - 2;                            /* Init binary search Hi  */

   /************************************************************************/
   /* Begin binary search algorithm for beginning time here                */
   /************************************************************************/
   
   NBytes = pTr->d_size;                          /* data record size      */
   while (Low <= Hi) {                            /* Binary Search Begins  */
      Mid = (Low + Hi) / 2;                       /* Begin at mid record   */
      RBeg = pTr->d_size * Mid;                   /* Bytes to mid rec      */
      rV = lseek (eX->fdd, RBeg, 0);              /* Go to mid rec         */
   
      Rsz = read (eX->fdd, eX->DATA_MEM, NBytes); /* read in data rec      */
      if (eX->BswaP)
         ReOrderUdf(1);

      Hdr = (pTr->HDR_OFF);                       /* ptr to hdr offs       */
      rV = lseek (eX->fdh, *Hdr, 0);              /* offset to header      */
      if ((Rv = ir_read_header (UDF)) != ALL_OKAY)  /* read header         */
      {
         if (ResetCalled)
            ginfo.called_locate = 0;
         return (Rv);                             /* no out with error     */
      }

   /************************************************************************/
   /*  Record seconds and nonosecond time                                  */
   /************************************************************************/

      rS = *(pTr->TIME) / 1000;
      rNs = (*(pTr->TIME) % 1000) * 1000000;

   /********************************************************************/
   /*  The requested start time is less than or equal to the time of   */
   /*  the record.                                                     */
   /********************************************************************/

      if (bY < *pTr->YEAR || (bY == *pTr->YEAR && bD < *pTr->DAYOFYEAR))
         Hi = Mid - 1;
      else if (bY == *pTr->YEAR && bD == *pTr->DAYOFYEAR && bS < rS)
         Hi = Mid - 1;
      else if (bY == *pTr->YEAR && bD == *pTr->DAYOFYEAR && bS == rS 
                && bN <= rNs)
	 Hi = Mid - 1;
      else if (bY == *pTr->YEAR && bD == *pTr->DAYOFYEAR && bS == rS 
               && bN == rNs)
         Hi = Mid - 1;

   /********************************************************************/
   /* The requested start time is greater than the time of the record. */
   /********************************************************************/
      
      else { Low = Mid + 1; }
   }

   /************************************************************************/
   /*  THERE are two different jumps. We are either jumping to the nearest */
   /*  data record or to the nearest sensor set.  In the first case the    */
   /*  the ending year will be negative.                                   */
   /*  First, however need to determine if we need to get a different data */
   /*  file for this time.  If its an earlier file then this should work   */
   /*  for both the fine and coarse positioning.                           */
   /************************************************************************/

   dY = bY - *pTr->YEAR;
   dD = bD - *pTr->DAYOFYEAR;
   dS = bS - *(pTr->TIME) / 1000;

   if (Low == 0 && (dY < 0 || (dY == 0 && dD < 0) || 
          (dY == 0 && dD == 0 && dS < 0))) {
      Rv = ReOpenFile (KeY, EX, VeR, UDF, bY, bD, bS, bN,
                                          eY, eD, eS, eN, FILE_BACK_UP);
      if (Rv != ALL_OKAY) {
         if (ResetCalled) { ginfo.called_locate = 0; }
         return (TIME_NOT_FOUND);
      }
   } else { 

   /************************************************************************/
   /* Coarse positioning - all use this                                    */
   /*   First step is to get to the data record after the requested time   */
   /************************************************************************/

      DonE = 0;
      while ((dY > 0 || (dY == 0 && dD > 0) || 
              (dY == 0 && dD == 0 && dS > 0)) && !DonE) {
         NBytes = pTr->d_size;
         Rsz = read (eX->fdd, eX->DATA_MEM, NBytes);
         if (Rsz <= 0) {
            Rv = ReOpenFile (KeY, EX, VeR, UDF, bY, bD, bS, bN,
                                          eY, eD, eS, eN, FILE_BACK_UP);
            if (Rv != ALL_OKAY) {
               if (ResetCalled) { ginfo.called_locate = 0; }
               return (TIME_NOT_FOUND);
            }
            DonE = 1;
         } else {
            if (eX->BswaP) { ReOrderUdf (1); }

            if (Rsz == NBytes) {
               rV = lseek (eX->fdh, (ByTe_4)*(pTr->HDR_OFF), SEEK_SET);
               Rv = ir_read_header (UDF);
               if (Rv == ALL_OKAY) {
                  dY = bY - *pTr->YEAR;
                  dD = bD - *pTr->DAYOFYEAR;
                  dS = bS - *(pTr->TIME) / 1000;
               } else { dS = 0; }
            }
            ++Mid;
         }
      }
       
   /************************************************************************/
   /*  If that worked now go back 2 data records and read the first.  That */
   /*   should put is in the data record containing the time               */
   /************************************************************************/

      if (dY < 0 || (dY == 0 && dD < 0) || (dY == 0 && dD == 0 && dS < 0)) {
         RBeg = -2 * pTr->d_size;
         if (lseek (eX->fdd, RBeg, SEEK_CUR) >= 0) {
            NBytes = pTr->d_size;
            Rsz = read (eX->fdd, eX->DATA_MEM, NBytes);
            if (Rsz <= 0) {
               lseek (eX->fdd, NBytes, SEEK_END);
               Rsz = read (eX->fdd, eX->DATA_MEM, NBytes);
               DonE = 1;
            }
            if(eX->BswaP) { ReOrderUdf (1); }

            if (Rsz == NBytes) {
               rV = lseek (eX->fdh, (ByTe_4)*(pTr->HDR_OFF), SEEK_SET);
               Rv = ir_read_header (UDF);
               if (Rv != ALL_OKAY) {
                  dS = 0;
                  dT = 1;
               } else { dT = bS - *(pTr->TIME) / 1000; }
            }

            if (dS < 0) dS = -dS;
            if ((dT > dS)  && !DonE) {
               NBytes = pTr->d_size * Mid;
               rV = lseek (eX->fdd, NBytes, SEEK_SET);
               NBytes = pTr->d_size;
               Rsz = read (eX->fdd, eX->DATA_MEM, NBytes);
               if (eX->BswaP) { ReOrderUdf (1); }
               rV = lseek (eX->fdh, (ByTe_4)*(pTr->HDR_OFF), SEEK_SET);
               Rv = ir_read_header (UDF);
            }
         }
      }
        
   /************************************************************************/
   /*  If we need to do a finer placement then do it here                  */
   /************************************************************************/

      if ( eY < 0 ) {
         pTr->time_row = 0;
         pTr->time_col = 0;
         pTr->cur_sen_set = 0;
         eX->accum_ss_sz = 0;
         pTr->reset_hdr = 1;
         eX->accum_ss_ms = 0;
         eX->accum_ss_ns = 0;
         pTr->chg_sen_set = 0;

   /************************************************************************/
   /*  If requested time is greater than the start time of the current     */
   /*  record, perform a fine search; otherwise, the requested time may    */
   /*  be before the time of the first record (a data gap) or the time     */
   /*  requested matches the start time of the data record.                */
   /************************************************************************/
   
         if (dY > 0|| (dY == 0 && dD > 0) || (dY == 0 && dD == 0 && dS > 0)) {

            rV = ir_fine_search (KeY, EX, VeR, UDF, bY, bD, bS, bN);

            Rv = ReOpenFile (KeY, EX, VeR, UDF, bY, bD, bS, bN,
                                                eY, eD, eS, eN, rV);

            if (Rv != ALL_OKAY) {
               if (ResetCalled) { ginfo.called_locate = 0; }
               return (TIME_NOT_FOUND);
            } else { eX->num_sample = (eX->smp_id == 2) ? 1 : *pTr->N_SAMPLE; }
         }
      } else {
         pTr->time_row = 0;
         pTr->time_col = 0;
         pTr->cur_sen_set = 0;
         eX->accum_ss_sz = 0;
         pTr->reset_hdr = 1;
         eX->accum_ss_ms = 0;
         eX->accum_ss_ns = 0;
         pTr->chg_sen_set = 0;
      }
   }

   eX->fnext = 1;
   pTr->reset_hdr = 1;

   if (ResetCalled)
     ginfo.called_locate = 0;
  
   return (ALL_OKAY);
}
