#ifdef WIN32
#include <windows.h>
#include <process.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "util_str.h"
#include "ret_codes.h"
#include "OpSySInD.h"
#include "libbase_udf.h"
#include "gen_defs.h"
#include "user_defs.h"
#ifndef WIN32
#include "PidfAnsi.h"
#endif
#include "Server.h"

/******************************************************************************
 *                                                                            *
 *                                 PromoteFile                                *
 *                                                                            *
 *  DESCRIPTION                                                               *
 *    This routine creates a promote file which is read by the PromoteUDF.    *
 *    It then uses this file to promote the data.                             *
 *                                                                            *
 *  INPUT VARIABLES                                                           *
 *    unsigned long data_key       key which uniquely identifies the data set *
 *                                 being processed                            *
 *    char *exten                  filename extension for the data to be used *
 *    unsigned short vnum          version number to be associated with this  *
 *                                 combination (allows for multiple opens)    *
 *    short btime_yr               start time requested (year component)      *
 *    short btime_day              start time requested (day component)       *
 *    long btime_sec               start time requested (seconds component)   *
 *    long btime_nsec              start time requested (nanoseconds)         *
 *    short etime_yr               stop time requested (year component)       *
 *    short etime_day              stop time requested (day component)        *
 *    long etime_sec               stop time requested (seconds component)    *
 *    long etime_nsec              stop time requested (nanoseconds)          *
 *                                                                            *
 *  USAGE                                                                     *
 *    rV = PromoteFile (ReQ Key, bYr, bDy, bMs, eYr, eDy, eMs, Pstat)         *
 *                                                                            *
 *  NECESSARY SUBPROGRAMS                                                     *
 *                                                                            *
 *****************************************************************************/

ByTe_2 PromoteFile (ByTe_1 *ReQ, u_ByTe_4 KeY,  
                      ByTe_2 bYr, ByTe_2 bDy, ByTe_4 bMs, 
                      ByTe_2 eYr, ByTe_2 eDy, ByTe_4 eMs, ByTe_2 Pstat ) 
{
   FILE *fo;
   extern char **environ;
   int pid, status;
 
   ByTe_2 rV = -1, Params[5];
   ByTe_1 PMEIV[200];
   ByTe_1 RunThis[250];
   ByTe_1 *argv[2];
   ByTe_1 *Fs = PathSep;
   ByTe_1 pF[250];

#ifdef WIN32
   char command[300];
   ByTe_4 KeysToStr (ByTe_2 *, ByTe_1 *);
   STARTUPINFO si;
   PROCESS_INFORMATION pi;
#endif

   /********************************************************************/
   /* Get the promote status - set to zero if no promote status        */
   /* exists:  Values are                                              */
   /*                                                                  */
   /*  -3 - Same as -2 but pops up NODATA window archive says NODATA   */
   /*  -2 - Auto promote all with Tcl indicator window if first open   */
   /*  -1 - Silently auto promote all if first open                    */
   /*   0 - Do no promotes                                             */
   /*   1 - Silently auto promote                                      */
   /*   2 - Auto promote with Tcl anouncement window                   */
   /*   3 - Same as 2 but pops up NODATA window archive says NODATA    */
   /********************************************************************/

   if (Pstat == 0) { return 0; }

   key_to_fields (KeY, Params);
   KeysToStr (Params, PMEIV);

#ifdef WIN32

   sprintf (pF, "%s%sbin%s.PrOmOtEuDf",getenv("UDFTOOL_HOME"), Fs, Fs);

#else

   sprintf (pF, ".PrOmOtEuDf");

#endif

      if ((fo = fopen(pF, "w")) != NULL) {
      fprintf (fo, "REQUEST    : %s\n", ReQ); 
      fprintf (fo, "PROJECT    : %s\n", &PMEIV[0]); 
      fprintf (fo, "MISSION    : %s\n", &PMEIV[40]); 
      fprintf (fo, "EXPERIMENT : %s\n", &PMEIV[80]); 
      fprintf (fo, "INSTRUMENT : %s\n", &PMEIV[120]); 
      fprintf (fo, "VIRTUAL    : %s\n", &PMEIV[160]); 
      fprintf (fo, "BEG YEAR   : %d\n", bYr);
      fprintf (fo, "BEG DAY    : %d\n", bDy);
      fprintf (fo, "BEG MSEC   : %d\n", bMs);
      fprintf (fo, "END YEAR   : %d\n", eYr);
      fprintf (fo, "END DAY    : %d\n", eDy);
      fprintf (fo, "END MSEC   : %d\n", eMs);
      fprintf (fo, "STATUS     : %d\n", Pstat);
      fclose (fo);
   }

#ifndef WIN32
   pid = fork();
   if (pid != -1 ) {
      if (pid == 0) {
         rV = 1;
         argv[0] = "PromoteUDF";
         argv[1] = 0;
         sprintf (RunThis, "%s%sbin%sPromoteUDF",
                    getenv("UDFTOOL_HOME"), Fs, Fs);

         execve(RunThis, argv, environ);
         exit(127);
      } 
      waitpid(pid, &status, 0);
   }

#else

   ZeroMemory(&si, sizeof(si));
   ZeroMemory(&pi,sizeof(pi));
   si.cb = sizeof(si);

   sprintf (RunThis, "tclsh \"%s%sbin%sPromoteUDF\"",
                    getenv("UDFTOOL_HOME"), Fs, Fs);

/* Command to execute ---> Example */

   sprintf(command,"cmd /C %s", RunThis );

/* StartProcess */

   if(
       !CreateProcess
       (
         NULL,
         command,
         NULL,
         NULL,
         FALSE,
         0,
         NULL,
         NULL,
         &si,
         &pi
       )
     )
   {
     printf("Error\n");
   }
 
   WaitForSingleObject(pi.hProcess, INFINITE);

/* Close Process and thread handles */

   CloseHandle(pi.hProcess);
   CloseHandle(pi.hThread);
#endif

   return 1;
}
