#include "util_str.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                           IR_OPER_ASGN SUBROUTINE                           *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine is called to set up the array of pointers to the routines   *
 *  that perform the arithmetic operations defined for the VIDF tables.        *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    None                                                                     *
 *                                                                             *
 *  USAGE                                                                      *
 *    oper_asgn ()                                                             *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    ir_idf_look_up()                performs the look up operation for a     *
 *                                    specified table                          *
 *    ir_idf_add()                    performs the addition operation for a    *
 *                                    specified table                          *
 *    ir_idf_subtract()               performs the subtraction operation for   *
 *                                    a specified table                        *
 *    ir_idf_multiply()               performs the multiplication operation    *
 *                                    for a specified table                    *
 *    ir_idf_divide()                 performs the division operation for a    *
 *                                    specified table                          *
 *    ir_idf_and()                    performs the logical AND operation for a *
 *                                    specified table                          *
 *    ir_idf_or()                     performs the logical OR operation for a  *
 *                                    specified table                          *
 *    ir_idf_shiftl()                 performs the shift left operation for a  *
 *                                    specified table                          *
 *    ir_idf_shiftr()                 performs the shift right operation for a *
 *                                    specified table                          *
 *    ir_combine_add()                performs the addition operation using the*
 *                                    permanent and temporary accumulators     *
 *    ir_combine_subtract()           performs the subtraction operation using *
 *                                    the permanent and temporary accumulators *
 *    ir_combine_multiply()           performs the multiplication operation    *
 *                                    using the permanent and temp accumulators*
 *    ir_combine_divide()             performs the division operation using    *
 *                                    the permanent and temporary accumulators *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    struct def_oper IDF_OPER[]      array of pointers to the routines that   *
 *                                    perform the arithmetic operation defined *
 *                                    for sensor, sweep, and cal. data tables  *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    None                                                                     *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void ir_oper_asgn (void)
{
   extern struct def_oper IDF_OPER[];

   IDF_OPER[0]._math_drv  = ir_idf_look_up;
   IDF_OPER[1]._math_drv  = ir_idf_add;
   IDF_OPER[2]._math_drv  = ir_idf_subtract;
   IDF_OPER[3]._math_drv  = ir_idf_multiply;
   IDF_OPER[4]._math_drv  = ir_idf_divide;
   IDF_OPER[5]._math_drv  = ir_idf_and;
   IDF_OPER[6]._math_drv  = ir_idf_or;
   IDF_OPER[7]._math_drv  = ir_idf_shiftr;
   IDF_OPER[8]._math_drv  = ir_idf_shiftl;
   IDF_OPER[9]._math_drv  = ir_idf_power;
   IDF_OPER[10]._math_drv  = ir_idf_mod;
   IDF_OPER[11]._math_drv  = ir_idf_exor;
   IDF_OPER[12]._math_drv  = ir_idf_inv;
}
