#include "util_str.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*****************************************************************************
 *                                                                           *
 *                       IR_INIT_EXPERIMENT_INFO SUBROUTINE                  *
 *                                                                           *
 *  DESCRIPTION                                                              *
 *    This routine is called to initialize a newly allocated experiment_info *
 *  structure, which indicates that a new data set has been encountered and  *
 *  is being processed.                                                      *
 *                                                                           *
 *  INPUT VARIABLES                                                          *
 *    short num                    index into the ginfo structure to get to  *
 *                                 the correct experiment_info structure     *
 *                                 just allocated for the new experiment     *
 *                                                                           *
 *  USAGE                                                                    *
 *    ir_init_experiment_info (num)                                          *
 *                                                                           *
 *  NECESSARY SUBPROGRAMS                                                    *
 *    None                                                                   *
 *                                                                           *
 *  EXTERNAL VARIABLES                                                       *
 *    struct general_info ginfo    structure that holds information concern- *
 *                                 ing the experiment that is being processed*
 *                                                                           *
 *  INTERNAL VARIABLES                                                       *
 *    struct experiment_info *ex   a pointer to the structure that holds     *
 *                                 specific experiment information           *
 *    short i                      looping variable                          *
 *                                                                           *
 *  SUBSYSTEM                                                                *
 *    Display Level                                                          *
 *                                                                           *
 *****************************************************************************/

void ir_init_experiment_info (ByTe_2 num)
{
   extern struct general_info ginfo;

   struct experiment_info *ex;
   ByTe_2 i;

  /***********************************************************************/
  /*  Point to the correct experiment_info structure and initialize the  */
  /*  elements.                                                          */
  /***********************************************************************/
 
   ex = ginfo.exbase + num;
   ex->fdh = -1;
   ex->fdd = -1;
   ex->fdi = -1;
   ex->inh = 0;
   ex->ind = 0;
   ex->ini = 0;
   ex->header_name[0] = '\0';
   ex->data_name[0]= '\0';
   ex->idf_name[0] = '\0';
   ex->exten[0] = '\0';
   ex->data_key = 0;
   ex->fnext = 0;
   ex->first_open = 1;
   ex->tdw_len = -1;
   ex->AncPBytes = 0;
   ex->AncGBytes = 0;
   ex->AncSBytes = 0;
   ex->AncSBits = 0;
   ex->num_of_plots = 0;
   ex->num_combo = 0;
   ex->first_select = 1;
   ex->DswaP = 1;
   ex->BswaP = 0;
   ex->los = 0;
   ex->next_offset = 0;
   ex->initial_gap = -1;
   ex->drec_eof = 0;
   ex->hrec_eof = 0;
   ex->version = 0;
   ex->pa_version = 0;
   ex->accum_ss_sz = 0;
   ex->accum_ss_ms = 0;
   ex->accum_ss_ns = 0;
   ex->cal_mod_swp = 0;
   ex->all_or_one = 0;
   ex->crit_action = 0;
   ex->scf_tie = 0;
   ex->btime_ms = 0;
   ex->btime_ns = 0;
   ex->etime_ms = 0;
   ex->etime_ns = 0;
   ex->pa_def = 0;

  /************************************************************************/
  /*  Initialize the information pertinent to the reading of VIDF data.   */
  /************************************************************************/

   ex->VIDF_INFO.version[0] = '\0';
   ex->VIDF_INFO.vidf_data = NO_MEMORY;
   ex->VIDF_INFO.tbl_offs = NO_MEMORY;
   ex->VIDF_INFO.const_offs = NO_MEMORY;
   ex->VIDF_INFO.info_off = 0;
   ex->VIDF_INFO.TABLES = 0;
   ex->VIDF_INFO.CONSTS = 0;
   for (i = 0; i < 72; ++i) { ex->VIDF_INFO.offsets[i] = 0; }

  /************************************************************************/
  /*  Set memory locations to indicate that no memory has been allocated  */
  /*  yet for the information of interest.                                */
  /************************************************************************/

   ex->d_type = NO_MEMORY;
   ex->sen_tdw_len = NO_MEMORY;
   ex->sen_status = NO_MEMORY;
   ex->sensors_needed = NO_MEMORY;
   ex->cal_target = NO_MEMORY;
   ex->tbl_type = NO_MEMORY;
   ex->tbl_var = NO_MEMORY;
   ex->tbl_expand = NO_MEMORY;
   ex->cal_wlen = NO_MEMORY;
   ex->constants = NO_MEMORY;
   ex->pitch_angles = NO_MEMORY;
   ex->bmem.base_tbl_index = NO_MEMORY;
   ex->bmem.base_hdr = NO_MEMORY;
   ex->bmem.base_data = NO_MEMORY;
   ex->bmem.base_info_ptr = NO_MEMORY;
   ex->bmem.base_sen_ptr = NO_MEMORY;
   ex->bmem.base_mode_ptr = NO_MEMORY;
   ex->bmem.base_constant = NO_MEMORY;
   ex->bmem.base_pitch_info = NO_MEMORY;
}
