#include <stdio.h>
#include <stdlib.h>
#include "OpSySInD.h"
#include "util_str.h"
#include "gen_defs.h"
#include "libbase_udf.h"

/*******************************************************************************
 *                                                                             *
 *                         FREE_EXPERIMENT_INFO SUBROUTINE                     *
 *                                                                             *
 *  DESCRIPTION                                                                *
 *    This routine is called to free all allocated experiment_info structures. *
 *  There should be one structure for each project/mission/experiment/virtual  *
 *  inst./extension/version that is processed.   This routine frees memory     *
 *  that was allocated to hold the information that is passed back to the user *
 *  by the READ_DREC() module.  Since this structure is used by both the       *
 *  graphical and tabular display software, this routine was created to be     *
 *  shared by both sets of software.                                           *
 *                                                                             *
 *  INPUT VARIABLES                                                            *
 *    None                                                                     *
 *                                                                             *
 *  USAGE                                                                      *
 *    free_experiment_info ()                                                  *
 *                                                                             *
 *  NECESSARY SUBPROGRAMS                                                      *
 *    ir_free_ex_structure()   frees all allocated memory associated with the  *
 *                             specified experiment_info structure             *
 *    ir_free_idf_data_ptr ()  frees the memory allocated within the idf_data  *
 *                             structure being processed                       *
 *    free ()                  frees previously allocated memory               *
 *                                                                             *
 *  EXTERNAL VARIABLES                                                         *
 *    struct general_info      structure that holds information concerning     *
 *        ginfo                the experiment that is being processed          *
 *    unsigned int Tmp_Bytes   number of bytes allocated for scratch space     *
 *    long InitIdfsEntry       variable used to safeguard against multiple     *
 *                             entries for this routine                        *
 *    void *Tmp_Space          scratch space for various uses                  *
 *                                                                             *
 *  INTERNAL VARIABLES                                                         *
 *    struct experiment_info   a pointer to the structure that holds specific  *
 *          *ex                experiment information                          *
 *    struct experiment_info   loop termination variable                       *
 *         *stop_ex                                                            *
 *    register int loop        looping variable                                *
 *                                                                             *
 *  SUBSYSTEM                                                                  *
 *    Display Level                                                            *
 *                                                                             *
 ******************************************************************************/

void free_experiment_info (void)
{
  extern struct general_info ginfo;
  extern size_t Tmp_Bytes;
  extern ByTe_4 InitIdfsEntry;
  extern void   *Tmp_Space;

  register struct experiment_info *ex, *stop_ex;
  register int loop;

  /***************************************************************************/
  /*  Loop over all defined experiment/virtual/extension comibinations.      */
  /***************************************************************************/

  if (ginfo.exbase != NO_MEMORY) {
     stop_ex = ginfo.exbase + ginfo.nds;
     for (ex = ginfo.exbase; ex < stop_ex; ++ex) {
        ir_free_ex_structure (ex);
     }

     /*************************************************************************/
     /*  Free the memory allocated for the pointers to the allocated data     */
     /*  structures.                                                          */
     /*************************************************************************/
   
     if (ginfo.idf_data_ptr != NO_MEMORY) {
        for (loop = 0; loop < ginfo.num_idf_data_ptr; ++loop) {
            ir_free_idf_data_ptr (*(ginfo.idf_data_ptr + loop));
            free (*(ginfo.idf_data_ptr + loop));
            *(ginfo.idf_data_ptr + loop) = NO_MEMORY;
         }

        free (ginfo.idf_data_ptr);
        ginfo.idf_data_ptr = NO_MEMORY;
        ginfo.num_idf_data_ptr = 0;
      }

     /*************************************************************************/
     /*  Free the memory allocated for the experiment_info structures.        */
     /*************************************************************************/
   
     if (ginfo.mexper != NO_MEMORY) {
        free (ginfo.mexper);
        ginfo.nds = 0;
        ginfo.pos_ex = 0;
        ginfo.exbase = NO_MEMORY;
        ginfo.expt = NO_MEMORY;
        ginfo.sexper = 0;
        ginfo.mexper = NO_MEMORY;
        ginfo.called_locate = 0;
        ginfo.next_version = 0;
        ginfo.idf_data_ptr = NO_MEMORY;
        ginfo.num_idf_data_ptr = 0;
      }
   }

  /*******************************************************************/
  /*  Free scratch space.                                            */
  /*******************************************************************/

  if (Tmp_Space != NO_MEMORY) {
     free (Tmp_Space);
     Tmp_Space = NO_MEMORY;
     Tmp_Bytes = 0;
   }

   InitIdfsEntry = 0;
}
