/***
 @(#)Server.h	1.9 97/07/23 SwRI
 ***/

#ifndef Server_H
#define Server_H

#include <stdio.h>
#include "dbf.h"
#include "DbDefs.h"
#include "LinkList.h"
#include "StrHier.h"
#include "ByteDefs.h"

#ifndef SUCCESS
#define SUCCESS 1
#endif
#ifndef FAILURE
#define FAILURE 0
#endif

/*
 * structure definitions
 */

typedef struct Time_s {
   ByTe_4 yr;      /* these two variables need to be long */ 
   ByTe_4 day;     /*  due to reading the database file   */
   ByTe_4 msec;
} Time_t;

typedef struct Promote_s {
   StrHier Src;
   Time_t Btime;
   Time_t Etime;
   int  State;
   int  IdfsType;
   LinkList EntryList;
   LinkList ServerList;
} Promote_t;

#define ONLINE  1
#define OFFLINE 2
#define IS_ONLINE(a) (ONLINE & a)
#define IS_OFFLINE(a) (OFFLINE & a)

#define _Ifile 1
#define _Hfile 2
#define _Dfile 4
#define _Pfile 8
#define _Sfile 16
#define IS_Ifile(a) (_Ifile & a)
#define IS_Hfile(a) (_Hfile & a)
#define IS_Dfile(a) (_Dfile & a)
#define IS_Pfile(a) (_Pfile & a)
#define IS_Sfile(a) (_Sfile & a)

typedef struct DbEntry_s {
   ByTe_1 VInst[9];        /* virtual instrument name       */
   Time_t BegTm;           /* begin time                    */
   Time_t EndTm;           /* end time                      */
   ByTe_4 Size;            /* size in bytes of data file(s) */
   ByTe_1 PreProc;         /* preprocessing flag            */
   ByTe_1 PostProc;        /* post processing flag          */
   ByTe_1 State[3];        /* state flag (reserved)         */
   ByTe_1 ArchLab[4];      /* archive index into archive label database */
   ByTe_1 Date[9];         /* date of arhive                */

   ByTe_1 *FName;            /* full path of data file        */
   ByTe_1 state;       /* 1 - online, 0 - offline, -1 - error */
   int recno;

   int  IdfsType;

   Promote_t *parent;
} DbEntry_t;

typedef struct Entry_s {
   ByTe_1 P[20];
   ByTe_1 S[20];
   ByTe_1 E[20];
   ByTe_1 I[20];
   ByTe_1 VI[20];
   ByTe_1 PostProc;
   ByTe_1 ArchLab[4];
   int state;
   ByTe_1 FName[256];
   LinkList ServerList; 
} Entry_t;

typedef struct Proc_s {
   ByTe_1 id;
   ByTe_1 *routine;
   ByTe_1 *ext;
} Proc_t;

typedef struct PidList_s {
   int pid;
   int fildes_0;
} PidList_t;

#if defined(__cplusplus)
extern "C" {
#endif

/******************************/
/*** libServer declarations ***/
/******************************/
/*
int AddToList( LinkList *List, int dbf, ByTe_1 *fname, Time_t btime,
               Time_t etime, StrHier Source, ByTe_1 *dbf, ByTe_1 *ndx,
               Promote_t *P );
*/
int AreWeSameArch( ByTe_1 * server, int *err );

int AutoDelete( Promote_t P );

int AutoPromote( Promote_t P );

int BuildDbList( Promote_t *P );

DbEntry_t *DbEntry( int dbf );

int CallWhichServers( ByTe_1 *server, int count, ByTe_1 *SelectedServerName, 
                      int CheckAllServers );

int     DePromote(StrHier, Time_t, Time_t);
int     DeleteList( LinkList );
int     EOLN( FILE *, ByTe_1 );
ByTe_1  *FetchData( ByTe_1 *);
StrHier FindInst1( LinkList, Promote_t);
ByTe_1  **FindNetIDs( int *);
void    FreeDbEntry(void *);
void    error_log( ByTe_1 *, ByTe_1*);

u_ByTe_4 GenKey1( Promote_t P );

ByTe_1 *GetHostAddr( ByTe_1 * host);

ByTe_1 *GetHostName( ByTe_1 * host );

int GetDataFile( ByTe_1 *volume, ByTe_1 *file, ByTe_1 *fullpathname, int length,
	         int cmptype, int preprocflag, ByTe_1 *SelectedServerName,
                 int CheckAllServers, ByTe_1 *dir );

ByTe_1 *GetPrePostExt( int flag );

int GetPostFlags( int flags );

int GetPreFlags( int flags );

ByTe_1 *GetVolume( ByTe_1 *id );

ByTe_1 *GetVolId( ByTe_1 *vol );

void* Get_DF( void* clt );

void* Get_DF_X( void* clt );

ByTe_1 * MakeFileName( ByTe_1 * vinst, Time_t time, ByTe_1 tail );

ByTe_1 *PostProcExt(ByTe_1 id);

ByTe_1 *PostProcRoutine(ByTe_1 id);

int PostProc(DbEntry_t *Entry);

int Process(ByTe_1 *arg0, ...);

int PromoDbEntries( Promote_t P, ByTe_1 * file, ByTe_1 ** server, 
                    int *count, int *err );

int PromoteList( LinkList EntryList, int XStatus );

int PromoteMeta (Promote_t * P, int n, int XStatus);

int PromotePidf( StrHier Src, ByTe_1 *IP_address, ByTe_1 *file, 
                 ByTe_1 *archnum );

int Read_Comments( FILE *, ByTe_1 symbol );

int RmDbEntries( Promote_t P, ByTe_1 * file, LinkList, int );

LinkList RmDups( LinkList L );

LinkList GetServers (LinkList ProjList, LinkList NewList);
LinkList ListServers( StrHier Src );

ByTe_1 *Strerror( int error );

int TellAllandPromote( LinkList  List );

int pbr( Time_t btime,  Time_t etime, StrHier src,
         int type, ByTe_1 *exten, ByTe_1 *fname, ByTe_4 *Tm );

int online( ByTe_1 *path );

int find_entry( int dbf, int ndx, ByTe_1 *vname, Time_t btime,
                Time_t etime, int mode );

int cmpTime( Time_t t1, Time_t t2);

int EntryChkSum(DbEntry_t *E);

int PromoteHDI(StrHier Src, DbEntry_t *Entry, ByTe_1 *IP_address);

int MkDbEntry(int Dbf, int Ndx, DbEntry_t *Entry, int Add);

int SetupForPromote (StrHier src, Time_t btime,  Time_t etime, int MetaPromote,
         int XStatus);

int PromoteAll(int XStatus);

void FreePromote_List();

#if defined(__cplusplus)
}
#endif

#ifndef MAXLINE
#define MAXLINE 512
#endif

/**********************/
/* Server Error Flags */
/**********************/

extern int s_errno;

#define S_EVOLNOTLOCAL -501   /* Volume in DB Not Local to Archive System */
#define S_EREADHD      -502   /* Volume in DB is Missing a 'H' or 'D' file online */ 
#define S_EREADVIDF    -503   /* Volume in DB does not have an 'I' file */ 
#define S_ECMPSIZE     -504   /* Compression size not found */ 
#define S_ECMPTYPE     -505   /* Compression type not found */ 
#define S_EZEROBYTE    -507   /* file is empty */
#define S_EFILESIZE    -508   /* file size is not correct */
#define S_EPROMOTE     -509   /* file can't be promoted */
#define S_ESTATE       -510   /* state not found */

/**********************/
/* Server Error Flags */
/**********************/

#define S_EVOLNOTFND   200     /* Volume in DB Not Found */
#define S_NOENT        201     /* No entries found */
#define S_SYS          202     /* system call error */
#define S_PRSE         203     /* Parse error */
#define S_CNFG         204     /* configuration error */
#define S_NORP         205     /* no response from server */
#define S_ENODATA      206     /* no data found */ 
#define S_NOTI         207     /* option not implemented yet */
#define S_NOADD        208     /* no entries added */
#define S_ADDEN        209     /* entries added */
#define S_PPERROR      210     /* Pre/Post processing error */
#define S_NOERROR      000     /* no error */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif
#ifndef MAXNAMLEN
#define MAXNAMLEN 255
#endif
#define TIMEOUT 90  /* Seconds */

/*
 * GLOBALS
 */

#endif
