#include "gph_str.h"
#include "gph_ansi.h"
#include <stdlib.h>

static ByTe_1 rcsid[] = "$Id: window.c,v 1.1 1999/11/21 07:46:16 chris.gurgiolo.b2r Stab chrisg $";

ByTe_1 window (ByTe_1 w, ByTe_1 *str)
{
   extern struct config   parm;
   extern struct memory   minfo;
   extern struct init_val ival;
   register struct window *wn, *wn_end;
   register struct graph  *gf, *gf_end;
   register ByTe_2 pos;
   ByTe_4  bytes;
   ByTe_2 free_wn = -1;
   ByTe_1 gw;

   bytes = sizeof (struct window);

   if (w < 0)
   {
      if (minfo.mgraf != NOMEM)
      {
         gw = -w - 1;
         gf = (struct graph *)minfo.mgraf;
         gf_end = gf + ival.graphs;
         for (; gf < gf_end; ++gf)
         { 
            if (gf->plotnm == gw)
            {
               parm.win = gf->gwn;
	       parm.wn_num = w;
	       return (gf->gwn->open);
            }	
         }
	 g_error (str,"NO DEFINED PLOTTING WINDOW",0);
	 return (-1);
      }
      else
      {
         g_error (str,"NO DEFINED PLOT STRUCTURE ARRAY",0);
	 return (-1);
      }
   }

   if (minfo.mwin == NOMEM)
   {
      bytes = ival.windows * bytes;
      if ((minfo.mwin = malloc (bytes)) == NOMEM)
         g_error (str,"CANNOT CREATE WINDOW STRUCTURE ARRAY",1);

      wn = (struct window *)minfo.mwin;
      wn_end = wn + ival.windows;
      for ( ; wn < wn_end; ++wn)
         wn->viewport = -1;
   }

   wn = (struct window *)minfo.mwin;
   wn_end = wn + ival.windows;
   for (pos = 0; wn < wn_end; ++wn, ++pos)
   {
      if (wn->viewport == w)
      {
         parm.win   = wn;
         parm.wn_num = w;
         return (wn->open);
      }
      else
	 if (wn->viewport == -1)
	   free_wn = pos;
   }

   if (free_wn >= 0)
      parm.win = (struct window *)minfo.mwin + free_wn;
   else
   {
      bytes = ++ival.windows * bytes;
      if ((minfo.mwin = realloc (minfo.mwin, bytes)) == NOMEM)
         g_error (str,"CANNOT EXPAND WINDOW STRUCTURE ARRAY",1);
      parm.win = (struct window *)minfo.mwin + ival.windows - 1;
   }

   parm.wn_num = w;
   close_win (w);
   parm.win->viewport = w;

   return (parm.win->open);
}
