#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: trnsfm_3D.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 trnsfm_3D(ByTe_2 npts)
{
   extern struct memory minfo;
   extern struct config parm;
   struct window *wn;
   register ReaL_4 *f1,*f2,*f3,*f4, *f5;
   register ByTe_1 *c1, *c2;
   ReaL_4 *f_end;
   ByTe_1  *c_end;
   ReaL_4 save[3];
   ReaL_4 offx,offy;
   ByTe_1 action;
   ReaL_4 r1[3],r2[3];
   ByTe_4 lst;
   ByTe_2 pnts = 0;
   ByTe_2 duo;
   ByTe_1 moved,ctp = 0,POLY = 0,FPOLY = 0;

   wn = parm.win;
   offx = (wn->plot[3] - wn->plot[0]) / 2.0;
   offy = (wn->plot[4] - wn->plot[1]) / 2.0;

   if (npts > 2)
   {
      lst = 3 * (npts - 1);
      f1 = (ReaL_4 *)minfo.mxyz;
      f2 = f1 + lst;
      f_end = f1 + 3;
      for ( ; f1 < f_end; )
	 if (*f1++ == *f2++)
	    ++POLY;
      FPOLY = (parm.fill >= 0 && POLY == 3) ? 1 : 0;
   }

   f1 = (ReaL_4 *)minfo.mxyz;
   f_end = f1 + 3 * npts;
   for ( ; f1 < f_end; )
   {
      f2 = save;
      for (f3 = wn->e_mat; f3 < wn->e_mat + 3; ++f3)
      {
         *f2  = *f1 * *f3; 
         *f2 += *(f1+1) * *(f3+4); 
         *f2 += *(f1+2) * *(f3+8); 
         *f2++ += *(f3+12); 
      }   
      f2 = save;
      *f1++ = *f2++ * wn->eye[6];
      *f1++ = *f2++ * wn->eye[7];
      *f1++ = *f2;
   }

   c1 = (ByTe_1 *) minfo.cmd;
   c2 = (ByTe_1 *) minfo.mxyz;
   f1 = (ReaL_4 *) minfo.mxyz;
   f2 = (ReaL_4 *) minfo.mxyz;
   f5 = (ReaL_4 *) minfo.mxy;
   f_end = f1 + 3 * npts;
   if (npts > 1) {
      for ( ; f1 < f_end; )
      {
         if (*c1 == 0) {
            ++c1; 
	    duo = 1;
            moved = 0;
	    for (f3 = r1; f3 < r1 + 3; )
	       *f3++ = *f1++; 
         }
         else 
           duo = 0;

         if (*c1 != 0) {
            ++c1;
            ++duo;
            for (f3 = r2, f4 = save; f3 < r2 + 3; )
            {
               *f3   = *f1++;
               *f4++ = *f3++;
            }
          }
          else
             continue;

         ctp = 0;
         if ((action = clip3d(r1,r2)) != 0) {
            if (duo == 1 && (action == 1 || action == 3)) {
	       ctp = (FPOLY && moved) ? 1 : 0;
	       duo = 2;
            }

            moved = 1;

	    if (duo == 2) {
	       *c2++ = ctp;
               *f5++ = offx * (-r1[0]/r1[2] + 1.0);
               *f5++ = offy * ( r1[1]/r1[2] + 1.0);
               ++pnts;
            }

            *c2++ = 1;
            *f5++ = offx * (-r2[0]/r2[2] + 1.0);
            *f5++ = offy * ( r2[1]/r2[2] + 1.0);
            ++pnts;
         }

         for (f3 = r1, f4 = save; f3 < r1 + 3; )
	    *f3++ = *f4++;
      }
   } else {
      for (f3 = r1; f3 < r1 + 3; )
          *f3++ = *f1++; 
      *f5++ = offx * (-r1[0]/r1[2] + 1.0);
      *f5++ = offy * ( r1[1]/r1[2] + 1.0);
   }

   if (FPOLY && pnts > 2)
   {
      f1 = (ReaL_4 *)minfo.mxy;
      if ((*(f1 + (pnts-1)*2) != *f1) || (*(f1 + (pnts-1)*2 + 1) != *(f1+1)))
      {
         ++pnts;
         *c2++ = 1;
         *f5++ = *f1++;
         *f5   = *f1;
      }
   }

   
   c1 = (ByTe_1 *)minfo.cmd;
   c2 = (ByTe_1 *)minfo.mxyz;
   c_end = c1 + pnts;
   for ( ; c1 < c_end; )
      *c1++ = *c2++;

   f1 = (ReaL_4 *)minfo.mxyz;
   f2 = (ReaL_4 *)minfo.mxy;
   f_end = f1 + 2 * npts;
   for ( ; f1 < f_end; )
   {
      *f1++ = *f2++;
      *f1++ = *f2++;
   }

   return (pnts);
}
