#include "gph_str.h"
#include "gph_ansi.h"
#include <math.h>

static ByTe_1 rcsid[] = "$Id: to_univcor.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";
	
ByTe_2 to_univcor (ByTe_2 n, ReaL_4 *r, ByTe_1 mode)
{
  extern struct config parm;
  extern struct memory minfo;
  extern struct init_val ival;
  struct window *wn;
  ByTe_2 npts;
  register ReaL_4 *f1,*f2,*f3,*f4;
  register ReaL_4 *f6,*f5;
  register ByTe_1  *c1;
  ReaL_4 *end1, *tmp;
  ReaL_4 *in,xo,yo;
  ReaL_4 ax,ay,by;
  ReaL_4 *out;
  ByTe_4 xyzpts,skip;
  ByTe_1 decra = 0,tuniv;
  ReaL_4 tsca[4],sca[4],x,y;
  ReaL_4 cor,off;

  wn     = (parm.alt_out > 3) ? parm.awin : parm.win;
  skip   = wn->dimen;
  npts   = skip * n;

  if (mode)
  {
     in  = (ReaL_4 *)minfo.mxyz;
     out = (ReaL_4 *)minfo.mxy;
     if (parm.alt_out > 1)
     {
        xyzpts = ival.points * 3;
        f1 = (parm.alt_out % 2 == 0) ? (ReaL_4 *)minfo.mxyz : 
                                              (ReaL_4 *)minfo.mxyz + xyzpts;
        f2 = (ReaL_4 *)minfo.mxyz + npts; 
        f3 = f2 + skip; 
        for ( ; f2 < f3;)
           *f2++ = *f1++;
        npts += skip;
	decra = 1;
        ++n;
     }
  }
  else
  {
     in  = r;
     out = r;
  }

  if (parm.univ > 3 && parm.univ < 8)
  {
      f1 = in;
      f2 = in + 1;
      f3 = f1 + npts;
      for (; f1 < f3; f1 += skip, f2 += skip)
      {
          x   = *f1 * cosin (*f2);
          y   = *f1 * sine (*f2);
          *f1 = x;
          *f2 = y;
      }
  }

  if (parm.univ > 7)
     tuniv = 0;
  else
     tuniv = (parm.univ < 4) ? parm.univ : parm.univ - 4;

  switch (tuniv) 
  {
     case 0:
        if (wn->skew)
	{
	   f1  = in; 
	   f2 = in + 1; 
	   f3 = wn->sk_cos;
	   f4 = wn->sk_sin;
           f5 = f1 + npts;
	   for ( ; f1 < f5; f1 += skip, f2 += skip)
	   {
	      x = *f1;
	      y = *f2;
              *f1   = x * *f3 - y * *(f4 + 1);
              *f2  = x * *f4 + y * *(f3 + 1);
           }
        }

        if (wn->ang[2] != 0) 
	{
           f1 = in;
           f2 = in + 1;
           f3 = f1 + npts;
           for (; f1 < f3; f1 += skip, f2 += skip)
           {
              x   =  *f1 * wn->trig[4] - *f2 * wn->trig[5];
              y   =  *f1 * wn->trig[5] + *f2 * wn->trig[4];
              *f1 = x;
              *f2 = y;
           }
        }

	f2 = in;
	c1  = wn->flip;
	for ( ; f2 < in + skip; ++f2)
           switch (*c1++) 
           {
              case 0:
                 break;
              case 1:
                 f3 = f2 + npts;
                 for (f1 = f2; f1 < f3; f1 += 3)
                    *f1 = -*f1;
                 break;
           }

        if (wn->dimen == 3) {
           if (!mode) {
              f6 = (ReaL_4 *)minfo.mxyz;
              *f6++ = in[0];
              *f6++ = in[1];
              *f6++ = in[2];
           }
	   n = trnsfm_3D (n);
           if (!mode) {
              f6 = (ReaL_4 *)minfo.mxyz;
              in[0] = *f6++;
              in[1] = *f6++;
           }
        }

        if (parm.alt_out >> 1 == 1)
	{
	   ay = (wn->plot[4] - wn->plot[1])/(wn->plot[3] - wn->plot[0]);
           by = *((ReaL_4 *)minfo.mxyz + xyzpts + 1) * (1 - ay);
           f2 = in + 2 * n;
           for (f1 = in + 1; f1 < f2; f1 += 2)
               *f1 = ay * *f1 + by;
	}

	f2 = in;
	tmp = out;
	c1  = wn->axis;
	f3 = wn->slope;
	f4 = wn->plot;
        end1 = in + 2;
        f5 = in + 2 * n;
	for ( ; f2 < end1; ++f3,++f4)
	{
	   f6 = tmp++;
	   if (*c1++)
	   {
              for (f1 = f2++; f1 < f5; f1 += 2,f6 += 2)
	      {
                  if ( *f1 <= 0 )
                  {
                     g_error ("TO_UNIVCOR","VALUE <= 0 WITH LOG SCALING",0);
                     *f1 = (*f4 < *(f4+3)) ?  -20 : 20;
                     *f6 = *f3 * *f1;
                  }
                  else
                     *f6 = *f3 * log10(*f1 / *f4);
               }
           }		
           else
           {
              for (f1 = f2++; f1 < f5; f1 += 2,f6 += 2)
                  *f6 = *f3 * (*f1 - *f4);
           }
        }
        break;

     case 1:
	f1 = in;
	f6 = out;
        f2 = in + 2 * n;
        for ( ; f1 < f2;)
               *f6++ = *f1++ * 32.0;
        break;

     case 2:
     case 3:
	f1 = in;
	f6 = out;
        f2 = in + 2 * n;
        for (; f1 < f2;)
	   *f6++ = *f1++;
        break;
   }

   if (tuniv >= 1 && tuniv <= 3 && parm.ostyle == 1)
   {
      f1 = out;
      f2 = out + 2 * n;
      for (; f1 < f2; f1 += 2)
        *f1 = 36767.0 - *f1;
   }

   if (decra)
      --n;
   parm.d2pts = n;

   if (parm.alt_out >> 1 == 1)
   {
      ax = wn->real[3] - wn->real[0];
      ay = wn->real[4] - wn->real[1];

      if (ax != ay)
      {
         f5 = (ReaL_4 *)minfo.mxy + n*2;
   
         if (ax > ay)
         {
	    cor = ay/ax;
	    f6 = out;
	    off = *f5 * (1 - cor); 
   
         }
         else
         {
	    cor = ax/ay;
	    f6 = out + 1;
	    off = *(f5 + 1) * (1 - cor); 
         }

         f1 = out + 2 * n;      
         for ( ; f6 < f1; f6 += 2)
	    *f6 = cor * *f6 + off; 
      }
   }
   
   if (parm.alt_out > 3)
   {
      get_wn_sc (sca,0);
      get_wn_sc (tsca,1);
      f5 = (ReaL_4 *)minfo.mxy + n*2;
      xo = (sca[0] - tsca[0]) * *f5++ + sca[2] - tsca[2]; 
      yo = (sca[1] - tsca[1]) * *f5 + sca[3] - tsca[3]; 
      f1 = out + 2 * n;      
      for ( f6 = out; f6 < f1; f6 += 2)
      {
         *f6 = (tsca[0] * *f6 + tsca[2] - sca[2] + xo)/sca[0]; 
         *(f6 + 1) = (tsca[1] * *(f6+1) + tsca[3] - sca[3] + yo)/sca[1]; 
      }
   }

   return (n);
}
