#include <string.h>
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: symbol_ch.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 symbol_ch (register ByTe_1 *w, ByTe_2 w_len, register ByTe_1 *ostr, 
                 ByTe_2 *len, ByTe_1 *c_info)
{
   ByTe_1 hold[80],chg[3];
   ByTe_1 c_font,c_case,c_type;
   register ByTe_1 *h;
   ByTe_2 cnt=0,spsb=1,adv;

   h = hold;
   *h = ']'; 
   *len = 0;
   *(c_info+1) = 'U';
   c_font = *c_info;
   c_case = *(c_info+1);
   c_type = *(c_info+2);

   switch (w_len) 
   {
      case 1:
         if (*w == '~')
             *h++ = ' ';
         break;
      case 2:
         switch (*w)
         {
            case '|':
               if (*w == '|' && *(w+1) == '|')
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '*';
               }
               break;
            case '>':
               if (*w == '>' && *(w+1) == '=')
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '+';
               }
               break;

            case '<':
               if (*w == '<' && *(w+1) == '=')
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '-';
               }
               else
                  if (*w == '<' && *(w+1) == '-')
                  {
                     c_font = 'G';
                     c_case = 'L';
                     c_type = *(c_info+3);
                     *h++ = '2';
                  }
               break;

            case '=':
               if (*w == '=' && *(w+1) == '=')
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '7';
               }
               break;

            case '!':
               if (*w == '!' && *(w+1) == '=')
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '$';
               }
               break;

            case '-':
               if (*w == '-' && *(w+1) == '>')
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '0';
               }
               break;

          }
          break;
      case 3:
         switch (*w) 
         {
            case 'A':
               if (!strcmp("ANG",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = 'K';
                  *h++ = '9';
               }
            break;
            case 'B':
               if (!strcmp("BOX",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = 'K';
                  *h++ = 'X';
               }
            break;
            case 'D':
               if (!strcmp("DEL",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '/';
               }
               else 
               {
                  if (!strcmp("DIA",w))
                  {
                     c_font = 'R';
                     c_case = 'L';
                     c_type = 'K';
                     *h++ = 'Z';
                  }
               }
            break;
            case 'I':
               if (!strcmp("INT",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '=';
               }
               else
                  if (!strcmp("INF",w))
                  {
                     c_font = 'R';
                     c_case = 'L';
                     c_type = *(c_info+3);
                     *h++ = ',';
                  }
               break;

            case 'P':
               if (!strcmp("PPD",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type =  'K';
                  *h++ = '8';
               }
               break;

            case 'S':
               if (!strcmp("SUB",w))
               {
                  *h++ = 39;
                  *h++ = 'B';
                  *h++ = 39;
                  cnt += 2;
                  spsb = 2;
               }
               else 
               {
                  if (!strcmp("SUP",w))
                  {
                     *h++ = 39;
                     *h++ = 'S';
                     *h++ = 39;
                     cnt += 2;
                     spsb = 2;
                  }
               }
               break;

            case 'V':
               if (!strcmp("VEC",w))
               {
                  c_font = 'G';
                  c_type =  (*(c_info+2) == 'K') ? 'I' : *(c_info+2);
                  strcpy (hold,"'V500H-1400L1'0'V-500'");
                  cnt += 21;
               }
               break;
         }
         break;
      case 4:
         switch (*w)
         {
            case 'B':
               if (!strcmp("BLOT",w))
               {
                  c_font = 'G';
                  c_case = 'U';
                  c_type = 'K';
                  *h++ = '+';
               }
               break;
            case 'C':
               if (!strcmp("CDOT",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '5';
               }
               else
                  if (!strcmp("CRLF",w))
                  {
                     *h++ = 39;
                     *h++ = 'C';
                     *h++ = 39;
                     cnt += 2;
                  }
               break;
            case 'D':
               if (!strcmp("DTRI",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = 'K';
                  *h++ = '/';
               }
               break;
            case 'F':
               if (!strcmp("FBOX",w))
               {
                  c_font = 'G';
                  c_case = 'U';
                  c_type = 'K';
                  *h++ = '-';
               }
               break;
            case 'G':
               if (!strcmp("GRAD",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '/';
               }
               break;
            case 'P':
               if (!strcmp("PROP",w))
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = ',';
               }
               break;
            case 'S':
               if (!strcmp("STAR",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = 'K';
                  *h++ = '-';
               }
               break;
         }
         break;
      case 5:
         switch (*w)
         {
            case 'A':
               if (!strcmp("APPOS",w))
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '4';
               }
               break;
            case 'F':
               if (!strcmp("FSTAR",w))
               {
                  c_font = 'G';
                  c_case = 'U';
                  c_type = 'K';
                  *h++ = ',';
               }
               else
               {
                  if (!strcmp("FDTRI",w))
                  {
                     c_font = 'G';
                     c_case = 'U';
                     c_type = 'K';
                     *h++ = '$';
                  }
                  else
                  {
                     if (!strcmp("FUTRI",w))
                     {
                        c_font = 'G';
                        c_case = 'U';
                        c_type = 'K';
                        *h++ = '*';
                     }
                  }
               }
               break;
            case 'I':
               if (!strcmp("INTER",w))
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '$';
               }
               break;
            case 'T':
               if (!strcmp("TIMES",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '4';
               }
               break;
            case 'U':
               if (!strcmp("UNION",w))
               {
                  c_font = 'G';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '*';
               }
               break;
         }
         break;
      case 6:
         switch (*w)
         {
            case 'A':
               if (!strcmp("APPROX",w))
               {
                  c_font = 'G';
                  c_case = 'U';
                  c_type = *(c_info+3);
                  *h++ = '.';
               }
               break;
            case 'C':
               if (!strcmp("CIRCLE",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = 'K';
                  *h++ = 'W';
               }
               break;
         }
         break;
      case 7:
         switch (*w)
         {
            case 'P':
               if (!strcmp("PARTIAL",w))
               {
                  c_font = 'R';
                  c_case = 'L';
                  c_type = *(c_info+3);
                  *h++ = '*';
               }
               break;
         }
         break;
   }

   if (hold[0] != ']')
   {
      ++cnt;
   
      chg[0] = (*c_info != c_font) ? 1 : 0;
      chg[1] = (*(c_info+1) != c_case) ? 1 : 0;
      chg[2] = (*(c_info+2) != c_type) ? 1 : 0;
            
      *c_info = c_font;
      *(c_info+1) = c_case;
      *(c_info+2) = c_type;
   
      adv = concat (hold,ostr,c_info,chg,cnt);
      *len += adv;
      return (spsb);
   }
   else
      return (0);
} 
