#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: strip_str.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_2 strip_str (register ByTe_1 *s, register ByTe_1 *sym, ByTe_1 delim, 
                 ByTe_2 *type)
{
    register ByTe_2 cnt = 0,i;
    ByTe_2 bra_cnt,ket_cnt;
    ByTe_1 *t_sym;
    ByTe_1 u_case = 0, l_case = 0;

    t_sym = sym;

    switch (delim)
    {
       default:
          while (*s != '\0' && *s != delim)
          {
               *sym++ = *s++;
               ++cnt;
          }
          *sym = '\0';

          if (*s == '\0')
	     g_error ("STRIP_STR", "MISSING TERMINATOR IN STRING",1);
          break;

       case ' ':
          while (*s != '\0' && *s != delim)
          {
               *sym++ = *s++;
               ++cnt;
          }
          *sym = '\0';

          for (i=0,sym=t_sym; i<cnt; ++i)
              if (*sym >= 'a' && *sym <= 'z')
                 l_case = 1;
              else
                 u_case = 1;
          if (l_case && u_case)
          {
             *type = 0;
             return (cnt);
          }
          if (u_case)
          {
             *type = 1;
             return (cnt);
          }
          if (l_case)
          {
             for (i=0,sym=t_sym; i<cnt; ++i)
                 *sym++ -= 32;
             *type = 2;
             return (cnt);
          }
          break;

       case '}':
          bra_cnt = 1;
          ket_cnt = 0;
          while (*s != '\0' && bra_cnt != ket_cnt)
          {
               if (*s == '{')
                  ++bra_cnt;
               else
                  if (*s == delim)
                     ++ket_cnt;
               *sym++ = *s++;
               ++cnt;
          }
          *(--sym) = '\0';

          if (*s == '\0' && bra_cnt != ket_cnt)
	     g_error ("STRIP_STR", "MISSING { OR } IN OUTPUT STRING",1);
          break;
        
    }
                 
    return (cnt);
}
