#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: skew_axis.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 skew_axis (ByTe_1 w, ByTe_1 axis, ReaL_4 ang)
{

   extern struct config parm;
   register struct window *wn;
   ByTe_2 ele;

   if (w != parm.wn_num)
      window (w,"SKEW_AXIS");

   wn = parm.win;

   ele = (axis > 'Z') ? axis - 'x' : axis - 'X';
   if (ele > 2 || ele < 0)
   {
      g_error ("SKEW_AXIS","UNKNOWN AXIS - SKEWING NOT SET",0); 
      return (0);
   }

   if (ang <= MIN_SKEW && ang >= -MIN_SKEW)
   {
      wn->skew_ang[ele] = 0;
      return (1);
   }

   wn->skew = 1;
   wn->skew_ang[ele] = 10 * ang;
   wn->sk_cos[ele] = cosin (ang);
   wn->sk_sin[ele] = sine (ang);
   return (1);
}
