#include "gph_str.h"
#include "gph_ansi.h"

static ByTe_1 rcsid[] = "$Id: set_win.c,v 1.1 1999/11/21 07:46:15 chris.gurgiolo.b2r Stab chrisg $";

ByTe_4 set_win (ByTe_1 w, ReaL_4 rx1, ReaL_4 ry1, ReaL_4 rz1, ReaL_4 rx2, 
                ReaL_4 ry2, ReaL_4 rz2, ReaL_4 px1, ReaL_4 py1, ReaL_4 pz1, 
                ReaL_4 px2, ReaL_4 py2, ReaL_4 pz2)
{
   extern struct config parm;
   register struct window *wn;
   register ReaL_4 *f1,*f2;
   ByTe_4 proj;
   ReaL_4 conv[4];
   ByTe_1 error = 0;

/*** check that window is totally contained within the plotting screen ***/

   if (rx1 >= 1.0 || ry1 >= 1.0 || rz1 >= 1.0)
   {
      g_error ("SET_WIN","WINDOW OFF SCREEN ; NOT OPENED",0);
      return (0);
   }

   window (w,"SET_WIN");

   if (parm.univ > 7)
   {
       proj = parm.univ - 8;
       map_limits (proj, px1, py1, px2, py2, conv);
       px1 = conv[0];
       py1 = conv[1];
       px2 = conv[2];
       py2 = conv[3];
   }

   wn = parm.win;
   wn->open = 1;
   wn->type = 1;
   wn->dimen = (pz1 != pz2) ? 3 : 2;

   f1 = wn->real;
   if (wn->pos_fmt == 1)
   {
      *f1++ = rx1 - rx2/2.0;
      *f1++ = ry1 - ry2/2.0;
      *f1++ = rz1 - rz2/2.0;
      *f1++ = rx1 + rx2/2.0;
      *f1++ = ry1 + ry2/2.0;
      *f1++ = rz1 + rz2/2.0;
   }
   else
   {
      *f1++ = rx1;
      *f1++ = ry1;
      *f1++ = rz1;
      if (wn->dis_fmt == 1)
      {
         *f1++ = rx1 + rx2;
         *f1++ = ry1 + ry2;
         *f1++ = rz1 + rz2;
      }
      else
      {
         *f1++ = rx2;
         *f1++ = ry2;
         *f1++ = rz2;
      }
   }

   for (f1 = wn->real, f2 = &wn->real[3]; f1 < wn->real + 3; ++f1,++f2)
   {
      if (*f1 < 0.0)
      {
	 error = 1;
         *f1 = 0.0;
      }
      if (*f2 > 1.0)
      {
	 error = 1;
         *f1 = 1.0;
      }
   }

   if (error)
      g_error ("SET_WIN","WINDOW OFF SCREEN - ADJUSTED",0);

   f1 = wn->plot;
   *f1++ = px1;
   *f1++ = py1;
   *f1++ = pz1;
   *f1++ = px2;
   *f1++ = py2;
   *f1++ = pz2;

   scale_win (3);
   return (1);
}
